/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.catalog.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jensoft.core.catalog.component.DemoTab;
import org.jensoft.core.catalog.component.DemoTabSet;
import org.jensoft.core.catalog.source.JavaSourcePane;
import org.jensoft.core.catalog.ui.ImageResource;
import org.jensoft.core.palette.color.JennyPalette;
import org.jensoft.core.view.View;

public class ViewFrameUI
extends JFrame {
    private static final long serialVersionUID = 416596322068922672L;
    private View view;

    public ViewFrameUI(View view) {
        this.view = view;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewFrameUI.this.create();
            }
        });
        this.pack();
        this.setSize(1024, 700);
    }

    public static void main(String[] args) {
        try {
            Class<?> viewClass = Class.forName(args[0]);
            View v = (View)viewClass.newInstance();
            ViewFrameUI viewFrameUI = new ViewFrameUI(v);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void create() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        ImageIcon iconFrame = ImageResource.getInstance().createImageIcon("jensoft.png", "");
        this.setIconImage(iconFrame.getImage());
        this.setTitle("JenSoft API");
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        JPanel masterPane = new JPanel();
        masterPane.setBackground(Color.BLACK);
        masterPane.setBorder(BorderFactory.createEmptyBorder(50, 50, 50, 50));
        masterPane.setLayout(new BorderLayout());
        DemoTabSet tabSet = new DemoTabSet();
        tabSet.setTitle("JenSoft");
        DemoTab demoTab = new DemoTab("Demo");
        demoTab.setTabColor(Color.DARK_GRAY);
        ImageIcon icon1 = ImageResource.getInstance().createImageIcon("demo.png", "");
        demoTab.setTabIcon(icon1);
        tabSet.addComandTab(demoTab, this.view);
        DemoTab viewSourceTab = new DemoTab("View");
        viewSourceTab.setTabColor(JennyPalette.JENNY6);
        ImageIcon icon = ImageResource.getInstance().createImageIcon("source.png", "");
        viewSourceTab.setTabIcon(icon);
        JavaSourcePane viewSource = new JavaSourcePane();
        tabSet.addComandTab(viewSourceTab, viewSource);
        viewSource.loadSource(this.view.getClass());
        demoTab.setSelected(true);
        masterPane.add((Component)tabSet, "Center");
        this.getContentPane().add((Component)masterPane, "Center");
        this.setVisible(true);
    }
}

