/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.catalog.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jensoft.core.catalog.component.DemoTab;
import org.jensoft.core.catalog.component.DemoTabSet;
import org.jensoft.core.catalog.source.JavaSourcePane;
import org.jensoft.core.catalog.source.X2DSourcePane;
import org.jensoft.core.catalog.ui.ImageResource;
import org.jensoft.core.palette.color.JennyPalette;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.view.View;
import org.jensoft.core.x2d.X2D;
import org.jensoft.core.x2d.X2DException;

public abstract class X2DFrameUI
extends JFrame {
    private static final long serialVersionUID = -7404344591674106627L;
    private String x2dResourcePath;

    public X2DFrameUI(String x2dResourcePath) {
        this.x2dResourcePath = x2dResourcePath;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                X2DFrameUI.this.create();
            }
        });
        this.pack();
        this.setSize(1024, 700);
    }

    private void create() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        ImageIcon iconFrame = ImageResource.getInstance().createImageIcon("jensoft.png", "");
        this.setIconImage(iconFrame.getImage());
        this.setTitle("JenSoft API");
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        JPanel masterPane = new JPanel();
        masterPane.setBackground(Color.BLACK);
        masterPane.setBorder(BorderFactory.createEmptyBorder(50, 50, 50, 50));
        masterPane.setLayout(new BorderLayout());
        DemoTabSet tabSet = new DemoTabSet();
        tabSet.setTitle("JenSoft - API");
        DemoTab demoTab = new DemoTab("Demo");
        demoTab.setTabColor(Color.DARK_GRAY);
        ImageIcon icon1 = ImageResource.getInstance().createImageIcon("demo.png", "");
        demoTab.setTabIcon(icon1);
        DemoTab sourceTab = new DemoTab("X2D");
        sourceTab.setTabColor(JennyPalette.JENNY6);
        ImageIcon icon = ImageResource.getInstance().createImageIcon("source.png", "");
        sourceTab.setTabIcon(icon);
        DemoTab uisourceTab = new DemoTab("Frame UI");
        uisourceTab.setTabColor(RosePalette.LEMONPEEL.brighter());
        ImageIcon icon2 = ImageResource.getInstance().createImageIcon("source.png", "");
        uisourceTab.setTabIcon(icon2);
        X2D x2d = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.x2dResourcePath);
            x2d = new X2D();
            x2d.registerX2D(inputStream);
        }
        catch (X2DException e) {
            e.printStackTrace();
        }
        View view = x2d.getView();
        tabSet.addComandTab(demoTab, view);
        X2D fx2d = x2d;
        JavaSourcePane uiSourcePane = new JavaSourcePane();
        tabSet.addComandTab(uisourceTab, uiSourcePane);
        X2DSourcePane x2dSourcePane = new X2DSourcePane();
        tabSet.addComandTab(sourceTab, x2dSourcePane);
        uiSourcePane.loadSource(this.getClass());
        x2dSourcePane.loadX2DSource(fx2d);
        demoTab.setSelected(true);
        masterPane.add((Component)tabSet, "Center");
        this.getContentPane().add((Component)masterPane, "Center");
        this.setVisible(true);
    }

    protected X2D getX2DFromClasspath(String x2dFileName) throws X2DException {
        InputStream inputStream = this.getClass().getResourceAsStream(x2dFileName);
        X2D x2d = new X2D();
        x2d.registerX2D(inputStream);
        return x2d;
    }
}

