/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.drawable.basic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import org.jensoft.core.drawable.Drawable;

public class QStar
implements Drawable {
    private double centerX;
    private double centerY;
    private double internalRadius;
    private double externalRadius;
    private double branchCount;
    double startAngleDegree = 60.0;
    private Shape starMorphe;

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public QStar(double x, double y, double internalRadius, double externalRadius, double branchCount) {
        this.centerX = x;
        this.centerY = y;
        this.internalRadius = internalRadius;
        this.externalRadius = externalRadius;
        this.branchCount = branchCount;
    }

    public QStar(double internalRadius, double externalRadius, double branchCount) {
        this.internalRadius = internalRadius;
        this.externalRadius = externalRadius;
        this.branchCount = branchCount;
    }

    public double getX() {
        return this.centerX;
    }

    public void setX(double x) {
        this.centerX = x;
    }

    public double getY() {
        return this.centerY;
    }

    public void setY(double y) {
        this.centerY = y;
    }

    public double getInternalRadius() {
        return this.internalRadius;
    }

    public void setInternalRadius(double internalRadius) {
        this.internalRadius = internalRadius;
    }

    public double getExternalRadius() {
        return this.externalRadius;
    }

    public void setExternalRadius(double externalRadius) {
        this.externalRadius = externalRadius;
    }

    public double getBranchCount() {
        return this.branchCount;
    }

    public void setBranchCount(double branchCount) {
        this.branchCount = branchCount;
    }

    public void createMorphe() {
        GeneralPath starMorphePath = new GeneralPath();
        double angleStar = 360.0 / this.branchCount;
        int i = 0;
        while ((double)i < this.branchCount) {
            double pXExternal = this.centerX + this.externalRadius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
            double pYExternal = this.centerY - this.externalRadius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
            double pXInternal = this.centerX + this.internalRadius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i + angleStar / 2.0));
            double pYInternal = this.centerY - this.internalRadius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i + angleStar / 2.0));
            double pXExternal2 = this.centerX + this.externalRadius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)(i + 1)));
            double pYExternal2 = this.centerY - this.externalRadius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)(i + 1)));
            QuadCurve2D.Double l = new QuadCurve2D.Double(pXExternal, pYExternal, pXInternal, pYInternal, pXExternal2, pYExternal2);
            starMorphePath.append(l, true);
            ++i;
        }
        starMorphePath.closePath();
        this.starMorphe = starMorphePath;
    }

    public Shape getStarMorphe() {
        this.createMorphe();
        return this.starMorphe;
    }

    @Override
    public void draw(Graphics2D g2d) {
        this.createMorphe();
        g2d.setColor(Color.RED);
        g2d.draw(this.starMorphe);
    }
}

