/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.drawable.screw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jensoft.core.drawable.Drawable;

public class Btr
implements Drawable {
    private double x;
    private double y;
    private double btrRadius;

    public Btr(double x, double y, double btrRadius) {
        this.x = x;
        this.y = y;
        this.btrRadius = btrRadius;
    }

    @Override
    public void draw(Graphics2D g2d) {
        Ellipse2D.Double bodyBTR = new Ellipse2D.Double(this.x - this.btrRadius, this.y - this.btrRadius, 2.0 * this.btrRadius, 2.0 * this.btrRadius);
        Area a = new Area(bodyBTR);
        Point2D.Double center = new Point2D.Double(this.x, this.y);
        double btrInternal = this.btrRadius - 3.0;
        float fraction = (float)(btrInternal / this.btrRadius);
        float[] dist0 = new float[]{0.5f, 1.0f};
        Color[] colors0 = new Color[]{Color.WHITE, Color.BLACK};
        RadialGradientPaint p0 = new RadialGradientPaint(center, (float)this.btrRadius, dist0, colors0, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2d.setPaint(p0);
        g2d.fill(a);
        GeneralPath starMorphePath = new GeneralPath();
        double angleStar = 60.0;
        for (int i = 0; i < 6; ++i) {
            double px = this.x + btrInternal * Math.cos(Math.toRadians(btrInternal + angleStar * (double)i));
            double py = this.y - btrInternal * Math.sin(Math.toRadians(btrInternal + angleStar * (double)i));
            if (i == 0) {
                starMorphePath.moveTo(px, py);
                continue;
            }
            starMorphePath.lineTo(px, py);
        }
        starMorphePath.closePath();
        float[] dist1 = new float[]{0.0f, 0.2f, 1.0f};
        Color[] colors1 = new Color[]{Color.DARK_GRAY, Color.GRAY, Color.BLACK};
        RadialGradientPaint p1 = new RadialGradientPaint(center, (float)btrInternal, dist1, colors1, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2d.setPaint(p1);
        g2d.fill(starMorphePath);
    }
}

