/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.drawable.screw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jensoft.core.drawable.Drawable;

public class Split
implements Drawable {
    private double flatRadius;
    private double internalRadius;
    private double x;
    private double y;
    private double angleDegree = 45.0;
    private double deltaDegree = 14.0;

    public Split(double x, double y, double flatRadius) {
        this.x = x;
        this.y = y;
        this.flatRadius = flatRadius;
    }

    public Split(double x, double y, double flatRadius, double angleDegree) {
        this.x = x;
        this.y = y;
        this.flatRadius = flatRadius;
        this.angleDegree = angleDegree;
    }

    @Override
    public void draw(Graphics2D g2d) {
        Ellipse2D.Double bodyFlat = new Ellipse2D.Double(this.getX() - this.flatRadius, this.getY() - this.flatRadius, 2.0 * this.flatRadius, 2.0 * this.flatRadius);
        Area a = new Area(bodyFlat);
        Point2D.Double center = new Point2D.Double(this.getX(), this.getY());
        float fraction = 0.0f;
        float[] dist0 = new float[]{fraction, 0.8f, 1.0f};
        Color[] colors0 = new Color[]{Color.LIGHT_GRAY, Color.GRAY, Color.BLACK};
        RadialGradientPaint p0 = new RadialGradientPaint(center, (float)this.flatRadius, dist0, colors0, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2d.setPaint(p0);
        g2d.fill(a);
        this.internalRadius = this.flatRadius - 2.0;
        Arc2D.Double arc1 = new Arc2D.Double(this.x - this.internalRadius, this.y - this.internalRadius, 2.0 * this.internalRadius, 2.0 * this.internalRadius, this.angleDegree - this.deltaDegree, 2.0 * this.deltaDegree, 0);
        Arc2D.Double arc2 = new Arc2D.Double(this.x - this.internalRadius, this.y - this.internalRadius, 2.0 * this.internalRadius, 2.0 * this.internalRadius, this.angleDegree - this.deltaDegree + 180.0, 2.0 * this.deltaDegree, 0);
        GeneralPath path = new GeneralPath();
        path.append(arc1, true);
        path.append(arc2, true);
        path.closePath();
        double p1x = this.x + this.internalRadius * Math.cos(Math.toRadians(this.angleDegree - this.deltaDegree));
        double p1y = this.y - this.internalRadius * Math.sin(Math.toRadians(this.angleDegree - this.deltaDegree));
        double p2x = this.x + this.internalRadius * Math.cos(Math.toRadians(this.angleDegree + 180.0 + this.deltaDegree));
        double p2y = this.y - this.internalRadius * Math.sin(Math.toRadians(this.angleDegree + 180.0 + this.deltaDegree));
        double p3x = this.x + this.internalRadius * Math.cos(Math.toRadians(this.angleDegree + this.deltaDegree));
        double p3y = this.y - this.internalRadius * Math.sin(Math.toRadians(this.angleDegree + this.deltaDegree));
        double p4x = this.x + this.internalRadius * Math.cos(Math.toRadians(this.angleDegree + 180.0 - this.deltaDegree));
        double p4y = this.y - this.internalRadius * Math.sin(Math.toRadians(this.angleDegree + 180.0 - this.deltaDegree));
        double pStartX = p1x + (p2x - p1x) / 2.0;
        double pStartY = p1y + (p2y - p1y) / 2.0;
        double pEndX = p3x + (p4x - p3x) / 2.0;
        double pEndY = p3y + (p4y - p3y) / 2.0;
        Point2D.Double start = new Point2D.Double(pStartX, pStartY);
        Point2D.Double end = new Point2D.Double(pEndX, pEndY);
        float[] dist = new float[]{0.0f, 0.5f, 1.0f};
        Color[] colors = new Color[]{Color.DARK_GRAY, Color.WHITE, Color.DARK_GRAY};
        LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
        g2d.setPaint(p);
        g2d.fill(path);
    }

    public double getFlatRadius() {
        return this.flatRadius;
    }

    public void setFlatRadius(double flatRadius) {
        this.flatRadius = flatRadius;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }
}

