/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.drawable.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.jensoft.core.drawable.Drawable;
import org.jensoft.core.graphics.Shader;

public class Label
implements Drawable {
    private String text;
    private Font font;
    private Color textColor;
    private int textPaddingX = 5;
    private int textPaddingY = 2;
    private Color outlineColor;
    private Stroke outlineStroke;
    private Color fillColor;
    private Shader shader;
    private double x;
    private double y;
    private Anchor anchor = Anchor.Center;

    @Override
    public void draw(Graphics2D g2d) {
        if (this.text == null || this.text.equals("")) {
            return;
        }
        if (this.font != null) {
            g2d.setFont(this.font);
        }
        FontMetrics fm = g2d.getFontMetrics();
        int textWidth = fm.stringWidth(this.text);
        int textHeight = fm.getHeight();
        int textAscent = fm.getAscent();
        int textDescent = fm.getDescent();
        if (this.anchor == Anchor.Center) {
            double xText = this.x - (double)(textWidth / 2);
            double yText = this.y;
        } else if (this.anchor == Anchor.South) {
            double xText = this.x - (double)(textWidth / 2);
            double yText = this.y - (double)this.textPaddingY - (double)textHeight;
        } else if (this.anchor == Anchor.North) {
            double xText = this.x - (double)(textWidth / 2);
            double yText = this.y + (double)this.textPaddingY + (double)textDescent;
        } else if (this.anchor == Anchor.West) {
            double xText = this.x - (double)(textWidth / 2);
            double yText = this.y;
        } else if (this.anchor == Anchor.East) {
            double xText = this.x - (double)(textWidth / 2);
            double yText = this.y;
        } else if (this.anchor == Anchor.Text) {
            double xText = this.x - (double)(textWidth / 2);
            double d = this.y;
        }
    }

    public static enum Anchor {
        North("North"),
        South("South"),
        West("West"),
        East("East"),
        Center("Center"),
        Text("Text");

        private String anchor;

        private Anchor(String anchor) {
            this.anchor = anchor;
        }

        public String getAnchor() {
            return this.anchor;
        }

        public void setAnchor(String anchor) {
            this.anchor = anchor;
        }
    }
}

