/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.drawable.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.drawable.Drawable;
import org.jensoft.core.glyphmetrics.GeometryPath;
import org.jensoft.core.glyphmetrics.GlyphUtil;

public class TextPath
implements Drawable {
    private GeometryPath geometryPath;
    private String label = "label";
    private GlyphVector glyphVector;
    private Font labelFont;
    private float glyphWidth;
    private int divergence = 10;
    private TextPosition textPosition = TextPosition.Left;
    private float offsetLeft = 10.0f;
    private float offsetRight = 10.0f;
    private Color textColor;
    private float[] fractions;
    private Color[] colors;
    private AffineTransform af;
    private PathSide pathSide = PathSide.Above;
    private boolean lockReverse = false;
    private boolean autoReverse = true;

    public TextPath() {
    }

    public void setPath(Shape shape) {
        this.geometryPath = new GeometryPath(shape);
    }

    public TextPath(Shape shape) {
        this.geometryPath = new GeometryPath(shape);
    }

    public boolean isLockReverse() {
        return this.lockReverse;
    }

    public void setLockReverse(boolean lockReverse) {
        this.lockReverse = lockReverse;
    }

    public boolean isAutoReverse() {
        return this.autoReverse;
    }

    public void setAutoReverse(boolean autoReverse) {
        this.autoReverse = autoReverse;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public PathSide getPathSide() {
        return this.pathSide;
    }

    public void setPathSide(PathSide pathSide) {
        this.pathSide = pathSide;
    }

    public TextPosition getTextPosition() {
        return this.textPosition;
    }

    public void setTextPosition(TextPosition textPosition) {
        this.textPosition = textPosition;
    }

    public int getDivergence() {
        return this.divergence;
    }

    public void setDivergence(int divergence) {
        this.divergence = divergence;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions == null || colors == null) {
            throw new IllegalArgumentException("fractions and/or colors array should be not null");
        }
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.fractions = fractions;
        this.colors = colors;
    }

    public float getOffsetLeft() {
        return this.offsetLeft;
    }

    public void setOffsetLeft(float offsetLeft) {
        this.offsetLeft = offsetLeft;
    }

    public float getOffsetRight() {
        return this.offsetRight;
    }

    public void setOffsetRight(float offsetRight) {
        this.offsetRight = offsetRight;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    @Override
    public void draw(Graphics2D g2d) {
        if (this.label == null) {
            return;
        }
        if (this.labelFont != null) {
            g2d.setFont(this.labelFont);
        } else {
            this.labelFont = g2d.getFont();
        }
        if (this.glyphVector == null) {
            this.glyphVector = this.labelFont.createGlyphVector(g2d.getFontRenderContext(), this.label);
            this.glyphWidth = GlyphUtil.getGlyphWidth(this.glyphVector);
        }
        this.af = new AffineTransform();
        float startLength = 0.0f;
        float endLength = 0.0f;
        Point2D pointStart = null;
        Point2D pointEnd = null;
        if (this.textPosition == TextPosition.Left) {
            startLength = this.offsetLeft;
            endLength = startLength + this.glyphWidth;
            pointStart = this.geometryPath.pointAtLength(startLength);
            pointEnd = this.geometryPath.pointAtLength(endLength);
        } else if (this.textPosition == TextPosition.Right) {
            startLength = this.geometryPath.lengthOfPath() - this.glyphWidth - this.offsetRight;
            endLength = startLength + this.glyphWidth;
            pointStart = this.geometryPath.pointAtLength(startLength);
            pointEnd = this.geometryPath.pointAtLength(endLength);
        } else if (this.textPosition == TextPosition.Middle) {
            startLength = this.geometryPath.lengthOfPath() / 2.0f - this.glyphWidth / 2.0f;
            endLength = startLength + this.glyphWidth;
            pointStart = this.geometryPath.pointAtLength(startLength);
            pointEnd = this.geometryPath.pointAtLength(endLength);
        }
        if (pointStart == null || pointEnd == null) {
            return;
        }
        boolean reverse = this.lockReverse;
        if (this.autoReverse && pointStart.getX() > pointEnd.getX()) {
            reverse = true;
        }
        for (int j = 0; j < this.glyphVector.getNumGlyphs(); ++j) {
            Point2D p = this.glyphVector.getGlyphPosition(j);
            float px = (float)p.getX();
            float py = (float)p.getY();
            Point2D pointGlyph = !reverse ? this.geometryPath.pointAtLength(startLength + GlyphUtil.getGlyphWidthAtToken(this.glyphVector, j)) : this.geometryPath.pointAtLength(endLength - GlyphUtil.getGlyphWidthAtToken(this.glyphVector, j));
            if (pointGlyph == null) continue;
            this.af.setToTranslation(pointGlyph.getX(), pointGlyph.getY());
            float angle = 0.0f;
            angle = !reverse ? this.geometryPath.angleAtLength(startLength + GlyphUtil.getGlyphWidthAtToken(this.glyphVector, j)) : this.geometryPath.angleAtLength(endLength - GlyphUtil.getGlyphWidthAtToken(this.glyphVector, j));
            if (!reverse) {
                this.af.rotate(angle);
            } else {
                this.af.rotate((double)angle + Math.PI);
            }
            if (!reverse) {
                if (this.pathSide == PathSide.Above) {
                    this.af.translate(-px, -py - (float)this.divergence);
                }
                if (this.pathSide == PathSide.Over) {
                    this.af.translate(-px, (double)(-py) + this.glyphVector.getVisualBounds().getHeight() / 2.0);
                }
                if (this.pathSide == PathSide.Below) {
                    this.af.translate(-px, (double)(-py) + this.glyphVector.getVisualBounds().getHeight() + (double)this.divergence);
                }
            } else {
                if (this.pathSide == PathSide.Above) {
                    this.af.translate(-px, (double)(-py) + this.glyphVector.getVisualBounds().getHeight() + (double)this.divergence);
                }
                if (this.pathSide == PathSide.Over) {
                    this.af.translate(-px, (double)(-py) + this.glyphVector.getVisualBounds().getHeight() / 2.0);
                }
                if (this.pathSide == PathSide.Below) {
                    this.af.translate(-px, -py - (float)this.divergence);
                }
            }
            Shape glyph = this.glyphVector.getGlyphOutline(j);
            Shape glyphTransformed = this.af.createTransformedShape(glyph);
            Rectangle2D glyphBound2D = this.glyphVector.getGlyphOutline(j).getBounds2D();
            Point2D.Double ptSrcNorth = new Point2D.Double(glyphBound2D.getBounds2D().getCenterX(), glyphBound2D.getBounds2D().getY());
            Point2D.Double ptDstNorth = new Point2D.Double();
            this.af.transform(ptSrcNorth, ptDstNorth);
            Point2D.Double ptSrcSouth = new Point2D.Double(glyphBound2D.getBounds2D().getCenterX(), glyphBound2D.getBounds2D().getY() + glyphBound2D.getBounds2D().getHeight());
            Point2D.Double ptDstSouth = new Point2D.Double();
            this.af.transform(ptSrcSouth, ptDstSouth);
            if (this.textColor != null) {
                g2d.setColor(this.textColor);
            } else {
                g2d.setColor(Color.BLACK);
            }
            if (this.fractions != null && ptDstNorth != null && ptDstSouth != null && !ptDstNorth.equals(ptDstSouth)) {
                LinearGradientPaint p2 = new LinearGradientPaint(ptDstNorth, ptDstSouth, this.fractions, this.colors);
                g2d.setPaint(p2);
            }
            g2d.fill(glyphTransformed);
        }
    }

    public static enum PathSide {
        Above("Above"),
        Over("Over"),
        Below("Below");

        private String pathSide;

        private PathSide(String side) {
            this.pathSide = side;
        }

        public String getPathSide() {
            return this.pathSide;
        }

        public static PathSide parse(String side) {
            if (Above.getPathSide().equals(side)) {
                return Above;
            }
            if (Over.getPathSide().equals(side)) {
                return Over;
            }
            if (Below.getPathSide().equals(side)) {
                return Below;
            }
            return Below;
        }
    }

    public static enum TextPosition {
        Left("Left"),
        Middle("Middle"),
        Right("Right");

        private String textPosition;

        private TextPosition(String position) {
            this.textPosition = position;
        }

        public String getTextPosition() {
            return this.textPosition;
        }

        public static TextPosition parse(String position) {
            if (Left.getTextPosition().equalsIgnoreCase(position)) {
                return Left;
            }
            if (Middle.getTextPosition().equalsIgnoreCase(position)) {
                return Middle;
            }
            if (Right.getTextPosition().equalsIgnoreCase(position)) {
                return Right;
            }
            return Middle;
        }
    }
}

