/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.glyphmetrics;

import java.awt.font.GlyphVector;

public class GlyphUtil {
    public static float[] getTokenWidths(GlyphVector glyphVector) {
        float[] widths = new float[glyphVector.getNumGlyphs()];
        for (int j = 0; j < glyphVector.getNumGlyphs(); ++j) {
            float width;
            widths[j] = width = (float)glyphVector.getGlyphLogicalBounds(j).getBounds2D().getWidth();
        }
        return widths;
    }

    public static float getTokenWidth(GlyphVector glyphVector, int tokenIndex) {
        return (float)glyphVector.getGlyphLogicalBounds(tokenIndex).getBounds2D().getWidth();
    }

    public static float getGlyphWidth(GlyphVector glyphVector) {
        float w = 0.0f;
        float[] widths = GlyphUtil.getTokenWidths(glyphVector);
        for (int i = 0; i < widths.length; ++i) {
            w += widths[i];
        }
        return w;
    }

    public static float getGlyphWidthAtToken(GlyphVector glyphVector, int tokenIndex) {
        if (tokenIndex < 0) {
            return 0.0f;
        }
        float w = 0.0f;
        float[] widths = GlyphUtil.getTokenWidths(glyphVector);
        for (int i = 0; i < tokenIndex; ++i) {
            w += widths[i];
        }
        return w;
    }
}

