/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.glyphmetrics.painter.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import org.jensoft.core.glyphmetrics.GlyphGeometry;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricDraw;

public class GlyphDefaultDraw
extends GlyphMetricDraw {
    private Color drawColor;

    public GlyphDefaultDraw(Color drawColor) {
        this.drawColor = drawColor;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    @Override
    public void paintGlyphMetricDraw(Graphics2D g2d, GlyphMetric glyphMetric) {
        List<GlyphGeometry> glyphShapes = glyphMetric.getMetricsGlyphGeometry();
        if (glyphShapes == null) {
            return;
        }
        g2d.setStroke(new BasicStroke(1.0f));
        for (GlyphGeometry glyphShape : glyphShapes) {
            g2d.setColor(this.drawColor);
            g2d.draw(glyphShape.getGlyphShape());
        }
    }
}

