/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.glyphmetrics.painter.marker;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.Side;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricMarkerPainter;

public class DefaultMarker
extends GlyphMetricMarkerPainter {
    private Color markerColor;
    private Stroke markerStroke;
    private int divergence = 2;

    public DefaultMarker(Color markerColor) {
        this.markerColor = markerColor;
    }

    public DefaultMarker(Color markerColor, int divergence) {
        this.markerColor = markerColor;
        this.divergence = divergence;
    }

    public DefaultMarker(Color markerColor, Stroke markerStroke, int divergence) {
        this.markerColor = markerColor;
        this.markerStroke = markerStroke;
        this.divergence = divergence;
    }

    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setMarkerColor(Color markerColor) {
        this.markerColor = markerColor;
    }

    public Stroke getMarkerStroke() {
        return this.markerStroke;
    }

    public void setMarkerStroke(Stroke markerStroke) {
        this.markerStroke = markerStroke;
    }

    public int getDivergence() {
        return this.divergence;
    }

    public void setDivergence(int divergence) {
        this.divergence = divergence;
    }

    @Override
    public void paintGlyphMetricMarker(Graphics2D g2d, GlyphMetric glyphMetric) {
        Point2D p;
        if (this.markerColor == null) {
            return;
        }
        g2d.setColor(this.markerColor);
        if (this.markerStroke != null) {
            g2d.setStroke(this.markerStroke);
        }
        if ((p = glyphMetric.getMetricPointRef()) == null) {
            return;
        }
        double px = glyphMetric.getRadialPoint(this.divergence, Side.SideLeft).getX();
        double py = glyphMetric.getRadialPoint(this.divergence, Side.SideLeft).getY();
        double px1 = glyphMetric.getRadialPoint(this.divergence, Side.SideRight).getX();
        double py1 = glyphMetric.getRadialPoint(this.divergence, Side.SideRight).getY();
        Line2D.Double l = new Line2D.Double(px, py, px1, py1);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.draw(l);
    }
}

