/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.glyphmetrics.painter.marker;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.Side;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricMarkerPainter;

public class RectangleMarker
extends GlyphMetricMarkerPainter {
    private Color startColor = Color.WHITE;
    private Color endColor = Color.BLACK;
    private int divergenceOrtho = 10;
    private int divergenceRadial = 5;
    private int globalRadialShift = 0;

    public RectangleMarker(Color startColor, Color endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
    }

    public RectangleMarker(Color startColor, Color endColor, int divergenceOrtho, int divergenceRadial) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.divergenceOrtho = divergenceOrtho;
        this.divergenceRadial = divergenceRadial;
    }

    public RectangleMarker(Color startColor, Color endColor, int divergenceOrtho, int divergenceRadial, int globalRadialShift) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.divergenceOrtho = divergenceOrtho;
        this.divergenceRadial = divergenceRadial;
        this.globalRadialShift = globalRadialShift;
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Color startColor) {
        this.startColor = startColor;
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setEndColor(Color endColor) {
        this.endColor = endColor;
    }

    public int getDivergenceOrtho() {
        return this.divergenceOrtho;
    }

    public void setDivergenceOrtho(int divergenceOrtho) {
        this.divergenceOrtho = divergenceOrtho;
    }

    public int getDivergenceRadial() {
        return this.divergenceRadial;
    }

    public void setDivergenceRadial(int divergenceRadial) {
        this.divergenceRadial = divergenceRadial;
    }

    public int getGlobalRadialShift() {
        return this.globalRadialShift;
    }

    public void setGlobalRadialShift(int globalRadialShift) {
        this.globalRadialShift = globalRadialShift;
    }

    @Override
    public void paintGlyphMetricMarker(Graphics2D g2d, GlyphMetric glyphMetric) {
        Point2D pLeft = glyphMetric.getOrthoLeftPoint(this.divergenceOrtho, this.globalRadialShift + this.divergenceRadial);
        if (pLeft == null) {
            return;
        }
        Point2D pRight = glyphMetric.getOrthoRightPoint(this.divergenceOrtho, this.globalRadialShift + this.divergenceRadial);
        if (pRight == null) {
            return;
        }
        Point2D pLeft2 = glyphMetric.getOrthoLeftPoint(this.divergenceOrtho, this.globalRadialShift - this.divergenceRadial);
        if (pLeft2 == null) {
            return;
        }
        Point2D pRight2 = glyphMetric.getOrthoRightPoint(this.divergenceOrtho, this.globalRadialShift - this.divergenceRadial);
        if (pRight2 == null) {
            return;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(pLeft.getX(), pLeft.getY());
        path.lineTo(pRight.getX(), pRight.getY());
        path.lineTo(pRight2.getX(), pRight2.getY());
        path.lineTo(pLeft2.getX(), pLeft2.getY());
        path.closePath();
        Point2D pStart = glyphMetric.getRadialPoint(this.globalRadialShift + this.divergenceRadial, Side.SideLeft);
        Point2D pEnd = glyphMetric.getRadialPoint(this.globalRadialShift + this.divergenceRadial, Side.SideRight);
        LinearGradientPaint lgp = new LinearGradientPaint(pStart, pEnd, new float[]{0.0f, 1.0f}, new Color[]{this.startColor, this.endColor});
        g2d.setPaint(lgp);
        g2d.fill(path);
    }
}

