/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.glyphmetrics.painter.marker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricMarkerPainter;

public class RoundMarker
extends GlyphMetricMarkerPainter {
    private Color markerFillColor;
    private Color markerDrawColor;
    private int radius = 3;

    public RoundMarker(Color markerFillColor) {
        this.markerFillColor = markerFillColor;
    }

    public RoundMarker(Color markerFillColor, Color markerDrawColor) {
        this.markerFillColor = markerFillColor;
        this.markerDrawColor = markerDrawColor;
    }

    public RoundMarker(Color markerFillColor, Color markerDrawColor, int radius) {
        this.markerFillColor = markerFillColor;
        this.markerDrawColor = markerDrawColor;
        this.radius = radius;
    }

    public Color getMarkerFillColor() {
        return this.markerFillColor;
    }

    public void setMarkerFillColor(Color markerFillColor) {
        this.markerFillColor = markerFillColor;
    }

    public Color getMarkerDrawColor() {
        return this.markerDrawColor;
    }

    public void setMarkerDrawColor(Color markerDrawColor) {
        this.markerDrawColor = markerDrawColor;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void paintGlyphMetricMarker(Graphics2D g2d, GlyphMetric glyphMetric) {
        Point2D p = glyphMetric.getMetricPointRef();
        if (p == null) {
            return;
        }
        if (this.markerFillColor != null || this.markerDrawColor != null) {
            Ellipse2D.Double marker = new Ellipse2D.Double(p.getX() - (double)this.radius, p.getY() - (double)this.radius, 2 * this.radius, 2 * this.radius);
            if (this.markerFillColor != null) {
                g2d.setColor(this.markerFillColor);
                g2d.fill(marker);
            }
            if (this.markerDrawColor != null) {
                g2d.setStroke(new BasicStroke());
                g2d.setColor(this.markerDrawColor);
                g2d.draw(marker);
            }
        }
    }
}

