/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.glyphmetrics.painter.marker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.Side;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricMarkerPainter;

public class TicTacMarker
extends GlyphMetricMarkerPainter {
    private Color tictacThemeColor;
    private int divergenceRight = 5;
    private int divergenceLeft = 5;
    private int size = 6;

    public TicTacMarker(Color tictacThemeColor) {
        this.tictacThemeColor = tictacThemeColor;
    }

    public TicTacMarker(Color tictacThemeColor, int size) {
        this.tictacThemeColor = tictacThemeColor;
        this.size = size;
    }

    public TicTacMarker(Color tictacThemeColor, int size, int divergence) {
        this.tictacThemeColor = tictacThemeColor;
        this.size = size;
        this.divergenceLeft = divergence;
        this.divergenceRight = divergence;
    }

    public TicTacMarker(Color tictacThemeColor, int size, int divergenceRight, int divergenceLeft) {
        this.tictacThemeColor = tictacThemeColor;
        this.size = size;
        this.divergenceLeft = divergenceLeft;
        this.divergenceRight = divergenceRight;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Color getTictacThemeColor() {
        return this.tictacThemeColor;
    }

    public void setTictacThemeColor(Color tictacThemeColor) {
        this.tictacThemeColor = tictacThemeColor;
    }

    public void setDivergence(int divergence) {
        this.divergenceLeft = divergence;
        this.divergenceRight = divergence;
    }

    public int getDivergenceRight() {
        return this.divergenceRight;
    }

    public void setDivergenceRight(int divergenceRight) {
        this.divergenceRight = divergenceRight;
    }

    public int getDivergenceLeft() {
        return this.divergenceLeft;
    }

    public void setDivergenceLeft(int divergenceLeft) {
        this.divergenceLeft = divergenceLeft;
    }

    @Override
    public void paintGlyphMetricMarker(Graphics2D g2d, GlyphMetric glyphMetric) {
        Point2D pLeft = glyphMetric.getRadialPoint(this.divergenceLeft, Side.SideLeft);
        if (pLeft == null) {
            return;
        }
        double pxLeft = pLeft.getX();
        double pyLeft = pLeft.getY();
        Point2D pRight = glyphMetric.getRadialPoint(this.divergenceRight, Side.SideRight);
        if (pRight == null) {
            return;
        }
        double pxRight = pRight.getX();
        double pyRight = pRight.getY();
        Line2D.Double l = new Line2D.Double(pxLeft, pyLeft, pxRight, pyRight);
        g2d.setStroke(new BasicStroke(new Float(this.size).floatValue(), 1, 1));
        BasicStroke bs = new BasicStroke(new Float(this.size).floatValue(), 1, 1);
        Shape st = bs.createStrokedShape(l);
        g2d.setColor(this.tictacThemeColor);
        g2d.fill(st);
        g2d.setStroke(new BasicStroke(4.0f));
        g2d.setColor(new Color(255, 255, 255, 60));
        g2d.draw(st);
    }
}

