/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.glyphmetrics.painter.path;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import org.jensoft.core.glyphmetrics.AbstractMetricsPath;
import org.jensoft.core.glyphmetrics.painter.AbstractPathPainter;

public class MetricsPathDefaultDraw
extends AbstractPathPainter {
    private Color pathDrawColor;
    private Stroke pathStroke;

    public MetricsPathDefaultDraw() {
        this.pathDrawColor = Color.BLACK;
    }

    public MetricsPathDefaultDraw(Color pathDrawColor) {
        this.pathDrawColor = pathDrawColor;
    }

    public MetricsPathDefaultDraw(Color pathDrawColor, Stroke pathStroke) {
        this.pathDrawColor = pathDrawColor;
        this.pathStroke = pathStroke;
    }

    public Color getPathDrawColor() {
        return this.pathDrawColor;
    }

    public void setPathDrawColor(Color pathDrawColor) {
        this.pathDrawColor = pathDrawColor;
    }

    public Stroke getPathStroke() {
        return this.pathStroke;
    }

    public void setPathStroke(Stroke pathStroke) {
        this.pathStroke = pathStroke;
    }

    @Override
    public void paintPath(Graphics2D g2d, AbstractMetricsPath metricsPath) {
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(this.pathDrawColor);
        if (this.getPathStroke() != null) {
            g2d.setStroke(this.getPathStroke());
        }
        Shape pathShape = metricsPath.getOrCreateGeometry().getPath();
        g2d.draw(pathShape);
    }
}

