/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.primitive.Node;
import org.jensoft.core.map.primitive.Primitive;
import org.jensoft.core.map.projection.Clearable;
import org.jensoft.core.map.projection.GeoBound;
import org.jensoft.core.map.projection.GeoPosition;
import org.jensoft.core.map.projection.Map2D;
import org.jensoft.core.map.projection.Projectable2D;
import org.jensoft.core.map.projection.Projection2D;

public abstract class AbstractMapLayer
implements Projectable2D,
Clearable {
    private boolean lock = false;
    private Projection2D projection2D;
    private GeoBound geoBound;
    private List<Primitive> primitives;
    private Interpolation interpolation = Interpolation.NearestNeighbor;
    private Antialiasing antialiasing = Antialiasing.Off;
    private Fractional fractional = Fractional.Off;

    public AbstractMapLayer() {
        this.primitives = new ArrayList<Primitive>();
    }

    public void registerPrimitive(Primitive primitive) {
        this.primitives.add(primitive);
    }

    public Projection2D getProjection2D() {
        return this.projection2D;
    }

    public void setProjection2D(Projection2D projection) {
        this.projection2D = projection;
    }

    @Override
    public void project() {
        for (Primitive p : this.primitives) {
            List<Node> nodes = p.getNodes();
            for (Node n : nodes) {
                GeoPosition gp = n.getGeoPosition();
                Point2D p2d = this.projection2D.geoToPixel(gp);
                n.setProjection(p2d);
            }
        }
    }

    @Override
    public void clearLayer() {
        this.clearPrimitives();
    }

    public void clearPrimitives() {
        this.primitives.clear();
    }

    public void lock() {
        this.lock = true;
    }

    public void unlock() {
        this.lock = false;
    }

    public boolean isLock() {
        return this.lock;
    }

    public GeoBound getGeoBound() {
        return this.geoBound;
    }

    public void setGeoBound(GeoBound geoBound) {
        this.geoBound = geoBound;
    }

    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(Interpolation interpolation) {
        this.interpolation = interpolation == null ? Interpolation.NearestNeighbor : interpolation;
    }

    public Antialiasing getAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(Antialiasing antialiasing) {
        this.antialiasing = antialiasing;
    }

    public void setFractionalMetrics(Fractional fractional) {
        this.fractional = fractional;
    }

    public Fractional getFractional() {
        return this.fractional;
    }

    private void setQuality(Graphics2D g2d) {
        this.getAntialiasing().configureGraphics(g2d);
        this.getInterpolation().configureGraphics(g2d);
        this.getFractional().configureGraphics(g2d);
    }

    public abstract void doPaintMap(Map2D var1);

    public abstract void doPaint(Graphics2D var1);

    public static enum Antialiasing {
        On(RenderingHints.VALUE_ANTIALIAS_ON),
        Off(RenderingHints.VALUE_ANTIALIAS_OFF);

        private Object value;

        private Antialiasing(Object value) {
            this.value = value;
        }

        private void configureGraphics(Graphics2D g) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.value);
        }
    }

    public static enum Fractional {
        On(RenderingHints.VALUE_FRACTIONALMETRICS_ON),
        Off(RenderingHints.VALUE_FRACTIONALMETRICS_OFF);

        private Object value;

        private Fractional(Object value) {
            this.value = value;
        }

        private void configureGraphics(Graphics2D g2d) {
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.value);
        }
    }

    public static enum Interpolation {
        Bicubic(RenderingHints.VALUE_INTERPOLATION_BICUBIC),
        Bilinear(RenderingHints.VALUE_INTERPOLATION_BILINEAR),
        NearestNeighbor(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);

        private Object value;

        private Interpolation(Object value) {
            this.value = value;
        }

        private void configureGraphics(Graphics2D g2d) {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.value);
        }
    }
}

