/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.highway;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import org.jensoft.core.map.layer.highway.Glyph;
import org.jensoft.core.map.layer.highway.HighwayPath;

public class GlyphLayout {
    private GlyphVector glyphVector;
    private GeneralPath path;
    private String text;
    private HighwayPath highwayPath;
    private FontRenderContext frc;
    private Font font;
    private int minOffset = 30;
    private Vector<Glyph> glyphItems = new Vector();

    public String getText() {
        return this.text;
    }

    public Vector<Glyph> getGlyphItems() {
        return this.glyphItems;
    }

    public GlyphLayout(String text, GeneralPath path, FontRenderContext frc, Font font) {
        this.text = text;
        this.font = font;
        this.frc = frc;
        this.path = path;
        this.highwayPath = new HighwayPath(path);
        this.glyphVector = font.createGlyphVector(frc, text);
    }

    private float[] getTokenWidths() {
        float[] widths = new float[this.glyphVector.getNumGlyphs()];
        for (int j = 0; j < this.glyphVector.getNumGlyphs(); ++j) {
            float width;
            this.glyphVector.getGlyphMetrics(j).getAdvanceX();
            widths[j] = width = (float)this.glyphVector.getGlyphLogicalBounds(j).getBounds2D().getWidth();
        }
        return widths;
    }

    private float getGlyphWidth() {
        float w = 0.0f;
        float[] widths = this.getTokenWidths();
        for (int i = 0; i < widths.length; ++i) {
            w += widths[i];
        }
        return w;
    }

    private float getGlyphWidthAtToken(int tokenIndex) {
        float w = 0.0f;
        float[] widths = this.getTokenWidths();
        for (int i = 0; i < tokenIndex; ++i) {
            w += widths[i];
        }
        return w;
    }

    public void calculateGlyph() {
        float place = this.getGlyphWidth() + (float)(2 * this.minOffset);
        float pl = this.highwayPath.lengthOfPath();
        int number = (int)(pl / place);
        if (number > 2) {
            number = 2;
        }
        float realPlace = pl / (float)number;
        float realOffset = (realPlace - this.getGlyphWidth()) / 2.0f;
        AffineTransform af = new AffineTransform();
        for (int i = 0; i < number; ++i) {
            Glyph item = new Glyph(this.text, i);
            this.glyphItems.add(item);
            for (int j = 0; j < this.glyphVector.getNumGlyphs(); ++j) {
                Point2D p = this.glyphVector.getGlyphPosition(j);
                float px = (float)p.getX();
                float py = (float)p.getY();
                Point2D pointGlyph = this.highwayPath.pointAtLength((float)i * realPlace + realOffset + this.getGlyphWidthAtToken(j));
                Shape glyph = this.glyphVector.getGlyphOutline(j);
                Rectangle2D glyphBound2D = this.glyphVector.getGlyphOutline(j).getBounds2D();
                float angle = this.highwayPath.angleAtLength((float)i * realPlace + realOffset + this.getGlyphWidthAtToken(j));
                af.setToTranslation(pointGlyph.getX(), pointGlyph.getY());
                af.rotate(angle);
                af.translate(-px, -py + 4.0f);
                Shape ts = af.createTransformedShape(glyph);
                item.addGlyphOutline(ts);
                Shape tsBound2D = af.createTransformedShape(glyphBound2D);
                item.addGlyphTransformBound(tsBound2D);
            }
        }
    }

    public int countItemLock() {
        int count = 0;
        for (Glyph gi : this.glyphItems) {
            if (!gi.islock()) continue;
            ++count;
        }
        return count;
    }

    public int countItem() {
        return this.glyphItems.size();
    }

    public void drawGlyph(Graphics2D g2d) {
        g2d.setFont(this.font);
        g2d.setColor(Color.DARK_GRAY);
        for (Glyph gi : this.glyphItems) {
            Vector<Shape> shapes = gi.getGlyphOutlines();
            if (!gi.islock()) continue;
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            for (Shape s : shapes) {
                g2d.setColor(Color.BLACK);
                g2d.fill(s);
            }
        }
    }
}

