/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.highway;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.AbstractMapLayer;
import org.jensoft.core.map.layer.highway.GlyphLayout;
import org.jensoft.core.map.layer.highway.Highway;
import org.jensoft.core.map.layer.highway.HighwayGroup;
import org.jensoft.core.map.layer.highway.HighwayNature;
import org.jensoft.core.map.layer.highway.MotorwayGroupRenderer;
import org.jensoft.core.map.layer.highway.PedestrianGroupRenderer;
import org.jensoft.core.map.layer.highway.PrimaryGroupRenderer;
import org.jensoft.core.map.layer.highway.SecondaryGroupRenderer;
import org.jensoft.core.map.layer.highway.Skelet;
import org.jensoft.core.map.layer.highway.TertiaryGroupRenderer;
import org.jensoft.core.map.layer.highway.TrunkGroupRenderer;
import org.jensoft.core.map.projection.Map2D;

public class HighwayLayer
extends AbstractMapLayer {
    private List<Highway> registeredHighways;
    private HighwayGroup serviceGroup;
    private HighwayGroup residentialGroup;
    private HighwayGroup tertiaryGroup;
    private HighwayGroup secondaryGroup;
    private HighwayGroup primaryGroup;
    private HighwayGroup unclassifiedGroup;
    private HighwayGroup roadGroup;
    private HighwayGroup motorwayGroup;
    private HighwayGroup motorwayLinkGroup;
    private HighwayGroup pedestrianGroup;
    private HighwayGroup trunkGroup;
    private HighwayGroup trunkLinkGroup;
    private PrimaryGroupRenderer primaryGroupRenderer;
    private SecondaryGroupRenderer secondaryGroupRenderer;
    private TertiaryGroupRenderer tertiaryGroupRenderer;
    private MotorwayGroupRenderer motorwayGroupRenderer;
    private PedestrianGroupRenderer pedestrianGroupRenderer;
    private TrunkGroupRenderer trunkGroupRenderer;
    private Color skeletBackground = Color.WHITE;
    private List<HighwayGroup> groups = new ArrayList<HighwayGroup>();

    public HighwayLayer() {
        this.registeredHighways = new ArrayList<Highway>();
        this.serviceGroup = new HighwayGroup(HighwayNature.SERVICE);
        this.residentialGroup = new HighwayGroup(HighwayNature.RESIDENTIAL);
        this.unclassifiedGroup = new HighwayGroup(HighwayNature.UNCLASSIFIED);
        this.tertiaryGroup = new HighwayGroup(HighwayNature.TERTIARY);
        this.secondaryGroup = new HighwayGroup(HighwayNature.SECONDARY);
        this.primaryGroup = new HighwayGroup(HighwayNature.PRIMARY);
        this.roadGroup = new HighwayGroup(HighwayNature.ROAD);
        this.motorwayGroup = new HighwayGroup(HighwayNature.MOTORWAY);
        this.motorwayLinkGroup = new HighwayGroup(HighwayNature.MOTORWAY_LINK);
        this.pedestrianGroup = new HighwayGroup(HighwayNature.PEDESTRIAN);
        this.trunkGroup = new HighwayGroup(HighwayNature.TRUNK);
        this.trunkLinkGroup = new HighwayGroup(HighwayNature.TRUNK_LINK);
        this.registerGroup(this.serviceGroup);
        this.registerGroup(this.residentialGroup);
        this.registerGroup(this.unclassifiedGroup);
        this.registerGroup(this.tertiaryGroup);
        this.registerGroup(this.secondaryGroup);
        this.registerGroup(this.primaryGroup);
        this.registerGroup(this.roadGroup);
        this.registerGroup(this.motorwayGroup);
        this.registerGroup(this.motorwayLinkGroup);
        this.registerGroup(this.pedestrianGroup);
        this.registerGroup(this.trunkGroup);
        this.registerGroup(this.trunkLinkGroup);
        this.primaryGroupRenderer = new PrimaryGroupRenderer();
        this.secondaryGroupRenderer = new SecondaryGroupRenderer();
        this.tertiaryGroupRenderer = new TertiaryGroupRenderer();
        this.motorwayGroupRenderer = new MotorwayGroupRenderer();
        this.pedestrianGroupRenderer = new PedestrianGroupRenderer();
        this.trunkGroupRenderer = new TrunkGroupRenderer();
    }

    public void registerHighway(Highway highway) {
        if (!this.isAlreadyRegister(highway)) {
            this.registeredHighways.add(highway);
            super.registerPrimitive(highway.getPrimitive());
        }
    }

    @Override
    public void clearLayer() {
        super.clearLayer();
        this.serviceGroup.clearGroup();
        this.residentialGroup.clearGroup();
        this.unclassifiedGroup.clearGroup();
        this.tertiaryGroup.clearGroup();
        this.secondaryGroup.clearGroup();
        this.primaryGroup.clearGroup();
        this.roadGroup.clearGroup();
        this.motorwayGroup.clearGroup();
        this.motorwayLinkGroup.clearGroup();
        this.pedestrianGroup.clearGroup();
        this.trunkGroup.clearGroup();
        this.trunkLinkGroup.clearGroup();
        this.registeredHighways.clear();
    }

    public void registerHighways(List<Highway> highways) {
        for (Highway h : highways) {
            this.registerHighway(h);
        }
    }

    private boolean isAlreadyRegister(Highway h) {
        for (Highway highway : this.registeredHighways) {
            if (!highway.equals(h)) continue;
            return true;
        }
        return false;
    }

    private void registerGroup(HighwayGroup group) {
        this.groups.add(group);
    }

    public List<Highway> getRegisteredHighways() {
        return this.registeredHighways;
    }

    public void resolveGroup() {
        this.serviceGroup.clearGroup();
        this.residentialGroup.clearGroup();
        this.unclassifiedGroup.clearGroup();
        this.tertiaryGroup.clearGroup();
        this.secondaryGroup.clearGroup();
        this.primaryGroup.clearGroup();
        this.roadGroup.clearGroup();
        this.motorwayGroup.clearGroup();
        this.motorwayLinkGroup.clearGroup();
        this.pedestrianGroup.clearGroup();
        this.trunkGroup.clearGroup();
        this.trunkLinkGroup.clearGroup();
        for (Highway h : this.registeredHighways) {
            String nature = h.getNature();
            if (nature.equals(HighwayNature.SERVICE)) {
                this.serviceGroup.addHighway(h);
            }
            if (nature.equals(HighwayNature.RESIDENTIAL)) {
                this.residentialGroup.addHighway(h);
            }
            if (nature.equals(HighwayNature.UNCLASSIFIED)) {
                this.unclassifiedGroup.addHighway(h);
            }
            if (nature.equals(HighwayNature.TERTIARY)) {
                this.tertiaryGroup.addHighway(h);
            }
            if (nature.equals(HighwayNature.SECONDARY)) {
                this.secondaryGroup.addHighway(h);
            }
            if (nature.equals(HighwayNature.PRIMARY)) {
                this.primaryGroup.addHighway(h);
            }
            if (nature.equals(HighwayNature.ROAD)) {
                this.roadGroup.addHighway(h);
            }
            if (nature.equals(HighwayNature.MOTORWAY)) {
                this.motorwayGroup.addHighway(h);
            }
            if (nature.equals(HighwayNature.MOTORWAY_LINK)) {
                this.motorwayLinkGroup.addHighway(h);
            }
            if (nature.equals(HighwayNature.PEDESTRIAN)) {
                this.pedestrianGroup.addHighway(h);
            }
            if (nature.equals(HighwayNature.TRUNK)) {
                this.trunkGroup.addHighway(h);
            }
            if (!nature.equals(HighwayNature.TRUNK_LINK)) continue;
            this.trunkLinkGroup.addHighway(h);
        }
    }

    public HighwayGroup getGroup(String nature) {
        for (HighwayGroup hg : this.groups) {
            if (!hg.getNature().equals(nature)) continue;
            return hg;
        }
        return null;
    }

    @Override
    public void doPaintMap(Map2D map2D) {
        this.project();
        this.resolveGroup();
        this.paintSkelet(map2D.getGraphics2D());
    }

    @Override
    public void doPaint(Graphics2D g2d) {
        this.project();
        this.resolveGroup();
        this.paintSkelet(g2d);
    }

    public void paintSkelet(Graphics2D g2d) {
        FontRenderContext frc = g2d.getFontRenderContext();
        Skelet skelet = new Skelet(frc);
        skelet.addHighwayGroup(this.serviceGroup);
        skelet.addHighwayGroup(this.residentialGroup);
        skelet.addHighwayGroup(this.unclassifiedGroup);
        skelet.addHighwayGroup(this.tertiaryGroup);
        skelet.addHighwayGroup(this.secondaryGroup);
        skelet.addHighwayGroup(this.primaryGroup);
        skelet.addHighwayGroup(this.roadGroup);
        skelet.addHighwayGroup(this.motorwayGroup);
        skelet.addHighwayGroup(this.motorwayLinkGroup);
        skelet.addHighwayGroup(this.pedestrianGroup);
        skelet.addHighwayGroup(this.trunkGroup);
        skelet.addHighwayGroup(this.trunkLinkGroup);
        skelet.makeOutlineSkelet();
        g2d.setColor(this.skeletBackground);
        g2d.fill(skelet.getSkeletPath());
        this.pedestrianGroupRenderer.paintHighwayGroup(g2d, this.pedestrianGroup);
        this.tertiaryGroupRenderer.paintHighwayGroup(g2d, this.tertiaryGroup);
        this.secondaryGroupRenderer.paintHighwayGroup(g2d, this.secondaryGroup);
        this.primaryGroupRenderer.paintHighwayGroup(g2d, this.primaryGroup);
        this.trunkGroupRenderer.paintHighwayGroup(g2d, this.trunkGroup);
        this.trunkGroupRenderer.paintHighwayGroup(g2d, this.trunkLinkGroup);
        this.motorwayGroupRenderer.paintHighwayGroup(g2d, this.motorwayGroup);
        this.motorwayGroupRenderer.paintHighwayGroup(g2d, this.motorwayLinkGroup);
        g2d.setColor(new Color(171, 158, 137));
        BasicStroke s = new BasicStroke(1.4f);
        g2d.setStroke(s);
        g2d.draw(skelet.getSkeletPath());
        skelet.makeGlyphSkelet();
        List<GlyphLayout> glayouts = skelet.getGlyphLayouts();
        for (int i = 0; i < glayouts.size(); ++i) {
            GlyphLayout gl = glayouts.get(i);
            gl.drawGlyph(g2d);
        }
    }

    public Color getSkeletBackground() {
        return this.skeletBackground;
    }

    public void setSkeletBackground(Color skeletBackground) {
        this.skeletBackground = skeletBackground;
    }
}

