/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.leisure;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.AbstractMapLayer;
import org.jensoft.core.map.layer.leisure.GardenLeisureRenderer;
import org.jensoft.core.map.layer.leisure.Leisure;
import org.jensoft.core.map.layer.leisure.LeisureNature;
import org.jensoft.core.map.layer.leisure.ParkLeisureRenderer;
import org.jensoft.core.map.layer.leisure.StadiumLeisureRenderer;
import org.jensoft.core.map.layer.leisure.WaterParkLeisureRenderer;
import org.jensoft.core.map.projection.Map2D;

public class LeisureLayer
extends AbstractMapLayer {
    private WaterParkLeisureRenderer waterParkLeisureRenderer;
    private StadiumLeisureRenderer stadiumLeisureRenderer;
    private ParkLeisureRenderer parkLeisureRenderer;
    private GardenLeisureRenderer gardenLeisureRenderer;
    private List<Leisure> registeredLeisures = new ArrayList<Leisure>();

    public LeisureLayer() {
        this.waterParkLeisureRenderer = new WaterParkLeisureRenderer();
        this.stadiumLeisureRenderer = new StadiumLeisureRenderer();
        this.parkLeisureRenderer = new ParkLeisureRenderer();
        this.gardenLeisureRenderer = new GardenLeisureRenderer();
    }

    public void registerLeisure(Leisure leisure) {
        if (!this.isAlreadyRegister(leisure)) {
            this.registeredLeisures.add(leisure);
            super.registerPrimitive(leisure.getPrimitive());
        }
    }

    public void registerLeisures(List<Leisure> leisures) {
        for (Leisure l : leisures) {
            this.registerLeisure(l);
        }
    }

    private boolean isAlreadyRegister(Leisure l) {
        for (Leisure leisure : this.registeredLeisures) {
            if (!leisure.equals(l)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doPaintMap(Map2D map2D) {
        this.project();
        Graphics2D g2d = map2D.getGraphics2D();
        for (Leisure l : this.registeredLeisures) {
            if (l.getNature().equals(LeisureNature.PARK)) {
                this.parkLeisureRenderer.paintLeisure(g2d, l);
            }
            if (l.getNature().equals(LeisureNature.WATER_PARK)) {
                this.waterParkLeisureRenderer.paintLeisure(g2d, l);
            }
            if (l.getNature().equals(LeisureNature.STADIUM)) {
                this.stadiumLeisureRenderer.paintLeisure(g2d, l);
            }
            if (!l.getNature().equals(LeisureNature.GARDEN)) continue;
            this.gardenLeisureRenderer.paintLeisure(g2d, l);
        }
    }

    @Override
    public void doPaint(Graphics2D g2d) {
        this.project();
        for (Leisure l : this.registeredLeisures) {
            if (l.getNature().equals(LeisureNature.PARK)) {
                this.parkLeisureRenderer.paintLeisure(g2d, l);
            }
            if (l.getNature().equals(LeisureNature.WATER_PARK)) {
                this.waterParkLeisureRenderer.paintLeisure(g2d, l);
            }
            if (l.getNature().equals(LeisureNature.STADIUM)) {
                this.stadiumLeisureRenderer.paintLeisure(g2d, l);
            }
            if (!l.getNature().equals(LeisureNature.GARDEN)) continue;
            this.gardenLeisureRenderer.paintLeisure(g2d, l);
        }
    }
}

