/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.leisure;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.jensoft.core.map.layer.leisure.Leisure;
import org.jensoft.core.map.layer.leisure.LeisureRenderer;
import org.jensoft.core.map.primitive.Node;

public class ParkLeisureRenderer
implements LeisureRenderer {
    @Override
    public boolean paintLeisure(Graphics2D g2d, Leisure leisure) {
        Polygon poly = new Polygon();
        for (Node n : leisure.getPrimitive().getNodes()) {
            poly.addPoint((int)n.getProjection().getX(), (int)n.getProjection().getY());
        }
        int centerX = (int)poly.getBounds2D().getCenterX();
        int centerY = (int)poly.getBounds2D().getCenterY();
        String name = leisure.getName();
        g2d.setFont(new Font("verdana", 0, 10));
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(name);
        g2d.setColor(new Color(167, 204, 149));
        g2d.fill(poly);
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.setStroke(new BasicStroke(1.3f));
        g2d.draw(poly);
        g2d.setStroke(new BasicStroke());
        Rectangle2D rect2D = poly.getBounds2D();
        if (name != null && !name.equals("")) {
            AttributedString label = new AttributedString(name);
            AttributedCharacterIterator paragraph = label.getIterator();
            int paragraphStart = paragraph.getBeginIndex();
            int paragraphEnd = paragraph.getEndIndex();
            LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, g2d.getFontRenderContext());
            float formatWidth = (float)rect2D.getWidth();
            float drawPosY = (float)rect2D.getCenterY();
            lineMeasurer.setPosition(paragraphStart);
            while (lineMeasurer.getPosition() < paragraphEnd) {
                TextLayout layout = lineMeasurer.nextLayout(formatWidth);
                float drawPosX = layout.isLeftToRight() ? (float)rect2D.getCenterX() : (float)rect2D.getCenterX() + formatWidth - layout.getAdvance();
                layout.draw(g2d, drawPosX, drawPosY += layout.getAscent());
                drawPosY += layout.getDescent() + layout.getLeading();
            }
        }
        return false;
    }
}

