/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.natural;

import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.natural.Coastline;
import org.jensoft.core.map.layer.natural.Coordinate;
import org.jensoft.core.map.layer.natural.LineString;
import org.jensoft.core.map.layer.natural.Natural;
import org.jensoft.core.map.layer.natural.Relio;
import org.jensoft.core.map.primitive.Node;
import org.jensoft.core.map.projection.GeoBound;
import org.jensoft.core.map.projection.GeoPosition;
import org.jensoft.core.map.projection.Projection2D;

public class CoastlineSkelet {
    private GeoBound geoBound;
    private Projection2D projection;
    private List<Natural> naturalsCoastlineSegments = new ArrayList<Natural>();
    private List<GeneralPath> closedPathCoastlines = new ArrayList<GeneralPath>();
    private List<LineString> linesIntersection = new ArrayList<LineString>();
    private List<Coastline> lineCoastline = new ArrayList<Coastline>();
    private List<Coastline> closedCoastline = new ArrayList<Coastline>();

    public CoastlineSkelet(GeoBound geoBound, Projection2D projection) {
        this.geoBound = geoBound;
        this.projection = projection;
    }

    public void register(Natural natural) {
        this.naturalsCoastlineSegments.add(natural);
    }

    public void createSkelet() {
        this.dumpBaseCoastline();
        this.initCoastline();
        this.makeLineCoastline();
        this.makeClosedCoastline();
        this.dumpMadeCoastline();
        this.createIntersection();
        this.createClosedPolygon();
    }

    public List<GeneralPath> getClosedPathCoastlines() {
        return this.closedPathCoastlines;
    }

    public Area getCoastlineSkelet() {
        double latNorth = this.geoBound.getLatitudeNorth();
        double latSouth = this.geoBound.getLatitudeSouth();
        double longWest = this.geoBound.getLongitudeWest();
        double longEast = this.geoBound.getLongitudeEast();
        Point2D p1 = this.projection.geoToPixel(new GeoPosition(latNorth, longWest));
        Point2D p2 = this.projection.geoToPixel(new GeoPosition(latNorth, longEast));
        Point2D p3 = this.projection.geoToPixel(new GeoPosition(latSouth, longWest));
        Point2D p4 = this.projection.geoToPixel(new GeoPosition(latSouth, longEast));
        GeneralPath gp = new GeneralPath();
        gp.moveTo(p1.getX(), p1.getY());
        gp.lineTo(p2.getX(), p2.getY());
        gp.lineTo(p4.getX(), p4.getY());
        gp.lineTo(p3.getX(), p3.getY());
        gp.closePath();
        Area area = new Area(gp);
        List<GeneralPath> closedCoastlinePath = this.getClosedPathCoastlines();
        for (int i = 0; i < closedCoastlinePath.size(); ++i) {
            Area sa = new Area(closedCoastlinePath.get(i));
            area.subtract(sa);
        }
        return area;
    }

    private void createClosedPolygon() {
        double latNorth = this.geoBound.getLatitudeNorth();
        double latSouth = this.geoBound.getLatitudeSouth();
        double longWest = this.geoBound.getLongitudeWest();
        double longEast = this.geoBound.getLongitudeEast();
        Point2D p1 = this.projection.geoToPixel(new GeoPosition(latNorth, longWest));
        Point2D p2 = this.projection.geoToPixel(new GeoPosition(latNorth, longEast));
        Point2D p3 = this.projection.geoToPixel(new GeoPosition(latSouth, longWest));
        Point2D p4 = this.projection.geoToPixel(new GeoPosition(latSouth, longEast));
        Relio relio = new Relio(p1.getX(), p2.getX(), p1.getY(), p3.getY());
        List<LineString> lss = this.getIntersection();
        for (LineString ls : lss) {
            relio.addInputOutput(ls);
        }
        relio.reliableIO();
        this.closedPathCoastlines.addAll(relio.getClosedPaths());
        for (Coastline c : this.closedCoastline) {
            LineString l = c.getGeometry();
            GeneralPath path = new GeneralPath();
            Coordinate[] C = l.getCoordinates();
            Coordinate cStart = C[0];
            path.moveTo(cStart.x, cStart.y);
            for (int i = 0; i < C.length; ++i) {
                path.lineTo(C[i].x, C[i].y);
            }
            path.closePath();
            this.closedPathCoastlines.add(path);
        }
    }

    private void createIntersection() {
        Rectangle2D polygon = this.getGeoBoundGeometry();
    }

    public List<LineString> getIntersection() {
        return this.linesIntersection;
    }

    private Rectangle2D getGeoBoundGeometry() {
        double latNorth = this.geoBound.getLatitudeNorth();
        double latSouth = this.geoBound.getLatitudeSouth();
        double longWest = this.geoBound.getLongitudeWest();
        double longEast = this.geoBound.getLongitudeEast();
        Point2D p1 = this.projection.geoToPixel(new GeoPosition(latNorth, longWest));
        Point2D p2 = this.projection.geoToPixel(new GeoPosition(latNorth, longEast));
        Point2D p3 = this.projection.geoToPixel(new GeoPosition(latSouth, longWest));
        Point2D p4 = this.projection.geoToPixel(new GeoPosition(latSouth, longEast));
        GeneralPath path = new GeneralPath();
        path.moveTo(p1.getX(), p1.getY());
        path.lineTo(p2.getX(), p2.getY());
        path.lineTo(p3.getX(), p3.getY());
        path.lineTo(p4.getX(), p4.getY());
        path.getBounds2D();
        return path.getBounds2D();
    }

    private void dumpBaseCoastline() {
        for (Natural n : this.naturalsCoastlineSegments) {
            System.out.println("COASTLINE SEGMENT :" + n.getId() + "; nodeStart=" + n.getPrimitive().getWay().getFirstNode().getId() + " nodeEnd=" + n.getPrimitive().getWay().getLastNode().getId() + "; closed :" + n.getPrimitive().getWay().isClosed() + "; primary segment :" + this.isPrimarySegment(n));
        }
        for (Natural n : this.naturalsCoastlineSegments) {
            System.out.println("CYCLIC SEGMENT :" + n.getId() + " :" + this.isCyclic(n));
        }
    }

    private void initCoastline() {
        for (Natural n : this.naturalsCoastlineSegments) {
            if (n.getPrimitive().getWay().isClosed()) {
                Coastline cClosed = new Coastline();
                cClosed.addSegment(n);
                this.closedCoastline.add(cClosed);
                continue;
            }
            if (!this.isPrimarySegment(n)) continue;
            Coastline c = new Coastline();
            c.addSegment(n);
            this.lineCoastline.add(c);
        }
    }

    private void makeLineCoastline() {
        for (Coastline c : this.lineCoastline) {
            boolean flag = true;
            Natural curentSegment = c.getLastSegment();
            while (flag) {
                if ((curentSegment = this.getNextSegment(curentSegment)) != null) {
                    c.addSegment(curentSegment);
                    continue;
                }
                flag = false;
            }
        }
    }

    private void makeClosedCoastline() {
        for (Natural n : this.naturalsCoastlineSegments) {
            if (!this.isCyclic(n)) continue;
            System.out.println("CYCLED MAKING :" + n.getId() + " cycled?:" + this.isAlreadyCycled(n));
            if (this.isAlreadyCycled(n)) continue;
            Coastline c = new Coastline();
            c.addSegment(n);
            this.closedCoastline.add(c);
            this.makeCycle(c);
        }
    }

    private boolean isAlreadyCycled(Natural n) {
        for (Coastline c : this.closedCoastline) {
            for (Natural ns : c.getSegments()) {
                if (!ns.equals(n)) continue;
                return true;
            }
        }
        return false;
    }

    private void makeCycle(Coastline c) {
        Natural curentSegment = c.getFirstSegment();
        while (!(curentSegment = this.getNextSegment(curentSegment)).equals(c.getFirstSegment())) {
            c.addSegment(curentSegment);
        }
        return;
    }

    private boolean isCyclic(Natural n) {
        Natural curentSegment = n;
        do {
            if ((curentSegment = this.getNextSegment(curentSegment)) != null) continue;
            return false;
        } while (!curentSegment.equals(n));
        return true;
    }

    private Natural getNextSegment(Natural n) {
        Node lastNodeSegment = n.getPrimitive().getWay().getLastNode();
        for (Natural nc : this.naturalsCoastlineSegments) {
            Node ln;
            if (nc.equals(n) || !(ln = nc.getPrimitive().getWay().getFirstNode()).equals(lastNodeSegment)) continue;
            return nc;
        }
        return null;
    }

    private void dumpMadeCoastline() {
        int i;
        for (Coastline c : this.closedCoastline) {
            System.out.println("CLOSED COASTLINE : " + c.countSegment());
            for (i = 0; i < c.countSegment(); ++i) {
                System.out.println("SEG :" + c.getSegment(i).getPrimitive().getWay().getId());
            }
        }
        for (Coastline c : this.lineCoastline) {
            System.out.println("LINE COASTLINE : " + c.countSegment());
            for (i = 0; i < c.countSegment(); ++i) {
                System.out.println("SEG :" + c.getSegment(i).getPrimitive().getWay().getId());
            }
        }
    }

    private boolean isPrimarySegment(Natural coastline) {
        Node startNode = coastline.getPrimitive().getWay().getNodes().get(0);
        boolean primary = true;
        for (Natural n : this.naturalsCoastlineSegments) {
            Node lastNode;
            if (n.equals(coastline) || !(lastNode = n.getPrimitive().getWay().getLastNode()).equals(startNode)) continue;
            primary = false;
        }
        return primary;
    }
}

