/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.rendering;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.AbstractMapLayer;
import org.jensoft.core.map.layer.background.BackgroundLayer;
import org.jensoft.core.map.layer.highway.GroupRenderingProperties;
import org.jensoft.core.map.layer.highway.HighwayGroup;
import org.jensoft.core.map.layer.highway.HighwayLayer;
import org.jensoft.core.map.layer.highway.HighwayNature;
import org.jensoft.core.map.layer.landuse.LanduseLayer;
import org.jensoft.core.map.layer.leisure.LeisureLayer;
import org.jensoft.core.map.layer.manmade.ManMadeLayer;
import org.jensoft.core.map.layer.natural.NaturalLayer;
import org.jensoft.core.map.layer.railway.RailwayLayer;
import org.jensoft.core.map.layer.waterway.WaterwayLayer;
import org.jensoft.core.map.primitive.Stream;
import org.jensoft.core.map.projection.DalleProjection;
import org.jensoft.core.map.projection.Map2D;
import org.jensoft.core.map.projection.MapUtil;
import org.jensoft.core.map.rendering.MapObjectToolkit;
import org.jensoft.core.map.restbridge.OSMRestBridgeEngine;

public class BordeauxRendedering {
    private OSMRestBridgeEngine osmRestBridge = new OSMRestBridgeEngine();
    private Map2D map2D;
    private List<AbstractMapLayer> layers;
    private static double longitude = -0.580577;
    private static double latitude = 44.841229;
    private static int zoom = 18;
    private BackgroundLayer backgroundLayer;
    private HighwayLayer highwayLayer;
    private NaturalLayer naturalLayer;
    private LeisureLayer leisureLayer;
    private LanduseLayer landuseLayer;
    private RailwayLayer railwayLayer;
    private ManMadeLayer manmadeLayer;
    private WaterwayLayer waterwayLayer;

    private void lookupOSM(int startX, int endX, int startY, int endY) {
        System.out.println("stream count:+" + (endX - startX) * (endY - startY));
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                Stream s = this.osmRestBridge.streamTile(x, y, 18);
                this.highwayLayer.registerHighways(MapObjectToolkit.createHighways(s));
                this.leisureLayer.registerLeisures(MapObjectToolkit.createLeisures(s));
                this.landuseLayer.registerLanduses(MapObjectToolkit.createLanduses(s));
                this.railwayLayer.registerRailways(MapObjectToolkit.createRailways(s));
                this.manmadeLayer.registerManMades(MapObjectToolkit.createManMade(s));
            }
        }
    }

    public Map2D createMap(int startX, int endX, int startY, int endY) {
        DalleProjection proj = new DalleProjection(zoom, 256);
        this.map2D = proj.createMap2D(startX, endX, startY, endY);
        this.backgroundLayer = new BackgroundLayer();
        this.highwayLayer = new HighwayLayer();
        this.naturalLayer = new NaturalLayer();
        this.leisureLayer = new LeisureLayer();
        this.landuseLayer = new LanduseLayer();
        this.railwayLayer = new RailwayLayer();
        this.manmadeLayer = new ManMadeLayer();
        this.waterwayLayer = new WaterwayLayer();
        this.layers = new ArrayList<AbstractMapLayer>();
        this.registerLayer(this.backgroundLayer);
        this.registerLayer(this.leisureLayer);
        this.registerLayer(this.landuseLayer);
        this.registerLayer(this.manmadeLayer);
        this.registerLayer(this.highwayLayer);
        this.registerLayer(this.railwayLayer);
        this.registerLayer(this.waterwayLayer);
        return this.map2D;
    }

    public void generateMap() {
        try {
            for (AbstractMapLayer layer : this.layers) {
                this.map2D.paint(layer);
            }
            String mapRootDirectoryT256 = "c:/usr/map-bordeaux/D18/T256";
            String mapRootTileDirectoryT256 = mapRootDirectoryT256 + File.separator + "tile";
            new File(mapRootDirectoryT256).mkdirs();
            new File(mapRootTileDirectoryT256).mkdirs();
            this.map2D.writeMap(mapRootDirectoryT256, "bordeaux-T256.png");
            this.map2D.writeTiles(mapRootTileDirectoryT256);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void configureMapRendering() {
        HighwayGroup residentialGroup = this.highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(14, Color.WHITE);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = this.highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(14, Color.WHITE);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup roadGroup = this.highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(14, Color.WHITE);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = this.highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = this.highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = this.highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup serviceGroup = this.highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(6, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup motorwayGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = this.highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(6, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
    }

    private void registerLayer(AbstractMapLayer layer) {
        this.layers.add(layer);
    }

    public static void main(String[] args) {
        BordeauxRendedering renderer = new BordeauxRendedering();
        int centerXIndex = MapUtil.longToX(longitude, zoom);
        int centerYIndex = MapUtil.latToY(latitude, zoom);
        int tileDelta = 2;
        int startX = centerXIndex - tileDelta;
        int endX = centerXIndex + tileDelta;
        int startY = centerYIndex - tileDelta;
        int endY = centerYIndex + tileDelta;
        renderer.createMap(startX, endX, startY, endY);
        renderer.configureMapRendering();
        renderer.lookupOSM(startX, endX, startY, endY);
        renderer.generateMap();
    }
}

