/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.rendering;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.highway.Highway;
import org.jensoft.core.map.layer.landuse.Landuse;
import org.jensoft.core.map.layer.leisure.Leisure;
import org.jensoft.core.map.layer.manmade.ManMade;
import org.jensoft.core.map.layer.natural.Natural;
import org.jensoft.core.map.layer.railway.Railway;
import org.jensoft.core.map.layer.waterway.Waterway;
import org.jensoft.core.map.primitive.Stream;
import org.jensoft.core.map.projection.GeoPosition;
import org.jensoft.core.map.projection.Map2D;
import org.jensoft.core.map.projection.MapUtil;
import org.jensoft.core.map.rendering.MapObjectToolkit;
import org.jensoft.core.map.rendering.RendererEngine;
import org.jensoft.core.map.restbridge.OSMRestBridgeEngine;
import org.jensoft.core.map.tile.Tile;

public class TotalPauEngine {
    private RendererEngine engine = new RendererEngine();
    private OSMRestBridgeEngine osmRestBridge = new OSMRestBridgeEngine();

    public void createTotalPauMap() {
        GeoPosition centerProjection = new GeoPosition(43.318637, -0.312383);
        int zoom = 17;
        int centerXIndex = MapUtil.longToX(centerProjection.getLongitude(), zoom);
        int centerYIndex = MapUtil.latToY(centerProjection.getLatitude(), zoom);
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        int tileDelta = 2;
        int startX = centerXIndex - tileDelta;
        int endX = centerXIndex + tileDelta;
        int startY = centerYIndex - tileDelta;
        int endY = centerYIndex + tileDelta;
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                Stream s = this.osmRestBridge.streamTile(x, y, zoom);
                Tile tile = new Tile(x, y, zoom);
                tiles.add(tile);
                List<Highway> highways = MapObjectToolkit.createHighways(s);
                List<Natural> naturals = MapObjectToolkit.createNatural(s);
                List<Leisure> leisures = MapObjectToolkit.createLeisures(s);
                List<Landuse> landuses = MapObjectToolkit.createLanduses(s);
                List<Railway> railways = MapObjectToolkit.createRailways(s);
                List<ManMade> manmades = MapObjectToolkit.createManMade(s);
                List<Waterway> waterways = MapObjectToolkit.createWaterways(s);
                tile.setHighways(highways);
                tile.setRailways(railways);
                tile.setWaterways(waterways);
                tile.setLanduses(landuses);
                tile.setLeisures(leisures);
                tile.setNaturals(naturals);
                tile.setManmades(manmades);
                this.engine.getManmadeLayer().registerManMades(manmades);
            }
        }
        try {
            String mapRootDirectoryT256 = "c:/usr/map-total-pau";
            new File(mapRootDirectoryT256).mkdirs();
            int level = 17;
            int x = MapUtil.longToX(centerProjection.getLongitude(), level);
            int y = MapUtil.latToY(centerProjection.getLatitude(), level);
            int delta = 2;
            Map2D map2D_17_256 = this.engine.createMapD17_256(x - delta, x + delta, y - delta, y + delta);
            map2D_17_256.writeMap(mapRootDirectoryT256, "laboratoire-total-pau-17.png");
            map2D_17_256.writeTiles(mapRootDirectoryT256);
            level = 18;
            x = MapUtil.longToX(centerProjection.getLongitude(), level);
            y = MapUtil.latToY(centerProjection.getLatitude(), level);
            delta = 4;
            Map2D map2D_18_256 = this.engine.createMapD18_256(x - delta, x + delta, y - delta, y + delta);
            map2D_18_256.writeMap(mapRootDirectoryT256, "laboratoire-total-pau-18.png");
            map2D_18_256.writeTiles(mapRootDirectoryT256);
            level = 19;
            x = MapUtil.longToX(centerProjection.getLongitude(), level);
            y = MapUtil.latToY(centerProjection.getLatitude(), level);
            delta = 8;
            Map2D map2D_19_256 = this.engine.createMapD19_256(x - delta, x + delta, y - delta, y + delta);
            map2D_19_256.writeMap(mapRootDirectoryT256, "laboratoire-total-pau-19.png");
            map2D_19_256.writeTiles(mapRootDirectoryT256);
            level = 20;
            x = MapUtil.longToX(centerProjection.getLongitude(), level);
            y = MapUtil.latToY(centerProjection.getLatitude(), level);
            delta = 16;
            Map2D map2D_20_256 = this.engine.createMapD20_256(x - delta, x + delta, y - delta, y + delta);
            map2D_20_256.writeMap(mapRootDirectoryT256, "laboratoire-total-pau-20.png");
            map2D_20_256.writeTiles(mapRootDirectoryT256);
            level = 21;
            x = MapUtil.longToX(centerProjection.getLongitude(), level);
            y = MapUtil.latToY(centerProjection.getLatitude(), level);
            delta = 14;
            Map2D map2D_21_256 = this.engine.createMapD21_256(x - delta, x + delta, y - delta, y + delta);
            map2D_21_256.writeTiles(mapRootDirectoryT256);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        TotalPauEngine testEngine = new TotalPauEngine();
        testEngine.createTotalPauMap();
    }
}

