/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.restbridge;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jensoft.core.map.layer.background.BackgroundLayer;
import org.jensoft.core.map.layer.highway.Highway;
import org.jensoft.core.map.layer.highway.HighwayLayer;
import org.jensoft.core.map.layer.highway.HighwayNature;
import org.jensoft.core.map.layer.landuse.Landuse;
import org.jensoft.core.map.layer.landuse.LanduseLayer;
import org.jensoft.core.map.layer.landuse.LanduseNature;
import org.jensoft.core.map.layer.leisure.Leisure;
import org.jensoft.core.map.layer.leisure.LeisureLayer;
import org.jensoft.core.map.layer.leisure.LeisureNature;
import org.jensoft.core.map.layer.manmade.ManMade;
import org.jensoft.core.map.layer.manmade.ManMadeLayer;
import org.jensoft.core.map.layer.manmade.ManMadeNature;
import org.jensoft.core.map.layer.natural.Natural;
import org.jensoft.core.map.layer.natural.NaturalLayer;
import org.jensoft.core.map.layer.natural.NaturalNature;
import org.jensoft.core.map.layer.railway.Railway;
import org.jensoft.core.map.layer.railway.RailwayLayer;
import org.jensoft.core.map.layer.railway.RailwayNature;
import org.jensoft.core.map.layer.railway.tramway.Tram;
import org.jensoft.core.map.layer.waterway.Waterway;
import org.jensoft.core.map.layer.waterway.WaterwayLayer;
import org.jensoft.core.map.layer.waterway.WaterwayNature;
import org.jensoft.core.map.primitive.Node;
import org.jensoft.core.map.primitive.Primitive;
import org.jensoft.core.map.primitive.Stream;
import org.jensoft.core.map.primitive.Tag;
import org.jensoft.core.map.primitive.Way;
import org.jensoft.core.map.projection.DalleProjection;
import org.jensoft.core.map.projection.MapUtil;
import org.jensoft.core.map.projection.Projection2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class OSMRestBridgeEngine {
    private DocumentBuilderFactory factory;
    private DocumentBuilder templateBuilder;
    private Document document;

    public OSMRestBridgeEngine() {
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.templateBuilder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void start() {
        DalleProjection d = new DalleProjection(17);
        int startX = 36335;
        int endX = 36350;
        int startY = 55805;
        int endY = 55820;
        double longWest = MapUtil.tile2long(startX, 17);
        double longEast = MapUtil.tile2long(endX + 1, 17);
        double latNorth = MapUtil.tile2lat(startY, 17);
        double latSouth = MapUtil.tile2lat(endY + 1, 17);
        BackgroundLayer backgroundLayer = new BackgroundLayer();
        NaturalLayer naturalLayer = new NaturalLayer();
        d.registerLayer(naturalLayer);
        WaterwayLayer waterwayLayer = new WaterwayLayer();
        d.registerLayer(waterwayLayer);
        LeisureLayer leisureLayer = new LeisureLayer();
        d.registerLayer(leisureLayer);
        LanduseLayer landuseLayer = new LanduseLayer();
        d.registerLayer(landuseLayer);
        ManMadeLayer manMadeLayer = new ManMadeLayer();
        d.registerLayer(manMadeLayer);
        HighwayLayer highwayLayer = new HighwayLayer();
        RailwayLayer railwayLayer = new RailwayLayer();
        d.registerLayer(railwayLayer);
    }

    private List<ManMade> makeBuildingManMades(List<Way> ways, Projection2D proj) {
        ArrayList<ManMade> manMades = new ArrayList<ManMade>();
        for (Way w : ways) {
            String nature = w.getTag(ManMadeNature.BUILDING_NATURE).getValue();
            ManMade manMade = new ManMade(w.getId(), nature);
            Primitive primitive = new Primitive(w);
            manMade.setPrimitive(primitive);
            manMades.add(manMade);
            if (w.getTag("name") == null) continue;
            manMade.setName(w.getTag("name").getValue());
        }
        return manMades;
    }

    private List<Waterway> makeWaterways(List<Way> ways, Projection2D proj) {
        ArrayList<Waterway> waterways = new ArrayList<Waterway>();
        for (Way w : ways) {
            String nature = w.getTag(WaterwayNature.NATURE).getValue();
            Waterway ww = new Waterway(w.getId(), nature);
            Primitive primitive = new Primitive(w);
            ww.setPrimitive(primitive);
            waterways.add(ww);
            if (w.getTag("name") == null) continue;
            ww.setName(w.getTag("name").getValue());
        }
        return waterways;
    }

    private List<Railway> makeRailways(List<Way> ways, Projection2D proj) {
        ArrayList<Railway> railways = new ArrayList<Railway>();
        for (Way w : ways) {
            String nature = w.getTag(RailwayNature.NATURE).getValue();
            if (!nature.equals(RailwayNature.TRAM)) continue;
            Tram tram = new Tram(w.getId(), nature);
            railways.add(tram);
            if (w.getTag("name") != null) {
                tram.setName(w.getTag("name").getValue());
            }
            Primitive primitive = new Primitive(w);
            tram.setPrimitive(primitive);
            for (Node n : w.getNodes()) {
                if (n.getTag("railway") == null || !n.getTag("railway").getValue().equals("halt")) continue;
                tram.addStop(n, n.getTag("name").getValue());
            }
        }
        return railways;
    }

    private List<Natural> makeNatural(List<Way> ways, Projection2D proj) {
        ArrayList<Natural> naturals = new ArrayList<Natural>();
        for (Way w : ways) {
            String nature = w.getTag(NaturalNature.NATURE).getValue();
            Natural natural = new Natural(w.getId(), nature);
            naturals.add(natural);
            if (w.getTag("name") != null) {
                natural.setName(w.getTag("name").getValue());
            }
            Primitive primitive = new Primitive(w);
            natural.setPrimitive(primitive);
        }
        return naturals;
    }

    private List<ManMade> makeManMades(List<Way> ways, Projection2D proj) {
        ArrayList<ManMade> manMades = new ArrayList<ManMade>();
        for (Way w : ways) {
            String nature = w.getTag(ManMadeNature.NATURE).getValue();
            ManMade manMade = new ManMade(w.getId(), nature);
            manMades.add(manMade);
            if (w.getTag("name") == null) continue;
            manMade.setName(w.getTag("name").getValue());
        }
        return manMades;
    }

    private List<Leisure> makeLeisures(List<Way> ways, Projection2D proj) {
        ArrayList<Leisure> leisures = new ArrayList<Leisure>();
        for (Way w : ways) {
            String nature = w.getTag(LeisureNature.NATURE).getValue();
            Leisure leisure = new Leisure(w.getId(), nature);
            leisures.add(leisure);
            if (w.getTag("name") == null) continue;
            leisure.setName(w.getTag("name").getValue());
        }
        return leisures;
    }

    private List<Landuse> makeLanduses(List<Way> ways, Projection2D proj) {
        ArrayList<Landuse> landuses = new ArrayList<Landuse>();
        for (Way w : ways) {
            String nature = w.getTag(LanduseNature.NATURE).getValue();
            Landuse landuse = new Landuse(w.getId(), nature);
            landuses.add(landuse);
            if (w.getTag("name") == null) continue;
            landuse.setName(w.getTag("name").getValue());
        }
        return landuses;
    }

    private List<Highway> makeHighways(List<Way> ways, Projection2D proj) {
        ArrayList<Highway> highways = new ArrayList<Highway>();
        for (Way w : ways) {
            String nature = w.getTag(HighwayNature.NATURE).getValue();
            Highway highway = new Highway(w.getId(), nature);
            Primitive primitive = new Primitive(w);
            highways.add(highway);
            if (w.getTag("name") != null) {
                highway.setName(w.getTag("name").getValue());
            }
            highway.setPrimitive(primitive);
        }
        return highways;
    }

    public String elementTextTrim(Element parent, String childName) {
        Element childElement = (Element)parent.getElementsByTagName(childName).item(0);
        if (childElement != null) {
            return childElement.getTextContent();
        }
        return null;
    }

    Stream streamBoundBox(double longitudeWest, double longEast, double latitudeNorth, double latitudeSouth) {
        Stream stream = new Stream();
        try {
            String bounding = "bbox=" + Double.toString(longitudeWest) + "," + Double.toString(latitudeSouth) + "," + Double.toString(longEast) + "," + Double.toString(latitudeNorth);
            String url = "http://api.openstreetmap.org/api/0.6/map?" + bounding;
            URL load = new URL(url);
            this.document = this.templateBuilder.parse(load.openStream());
            Element root = this.document.getDocumentElement();
            NodeList wayList = root.getElementsByTagName("way");
            for (int i = 0; i < wayList.getLength(); ++i) {
                org.w3c.dom.Node wayNode = wayList.item(i);
                Way way = new Way();
                stream.addWay(way);
                NamedNodeMap wayAttributes = wayNode.getAttributes();
                for (int a = 0; a < wayAttributes.getLength(); ++a) {
                    org.w3c.dom.Node theAttribute = wayAttributes.item(a);
                    String attName = theAttribute.getNodeName();
                    String attValue = theAttribute.getNodeValue();
                    if (attName != null && attName.equals("id")) {
                        way.setId(Integer.parseInt(attValue));
                    }
                    if (attName != null && attName.equals("timestamp")) {
                        way.setTimestamp(attValue);
                    }
                    if (attName == null || !attName.equals("user")) continue;
                    way.setUser(attValue);
                }
                NodeList nodeWayList = wayNode.getChildNodes();
                for (int j = 0; j < nodeWayList.getLength(); ++j) {
                    NamedNodeMap childAttributes;
                    org.w3c.dom.Node wayChild = nodeWayList.item(j);
                    String nodeName = wayChild.getNodeName();
                    if (nodeName.equals("nd")) {
                        childAttributes = wayChild.getAttributes();
                        for (int a = 0; a < childAttributes.getLength(); ++a) {
                            org.w3c.dom.Node theAttribute = childAttributes.item(a);
                            String attName = theAttribute.getNodeName();
                            String attValue = theAttribute.getNodeValue();
                            if (attName == null || !attName.equals("ref")) continue;
                            way.addNodeRef(Integer.parseInt(attValue));
                        }
                        continue;
                    }
                    if (!nodeName.equals("tag")) continue;
                    childAttributes = wayChild.getAttributes();
                    Tag t = new Tag();
                    for (int a = 0; a < childAttributes.getLength(); ++a) {
                        org.w3c.dom.Node theAttribute = childAttributes.item(a);
                        String attName = theAttribute.getNodeName();
                        String attValue = theAttribute.getNodeValue();
                        if (attName != null && attName.equals("k")) {
                            t.setKey(attValue);
                        }
                        if (attName == null || !attName.equals("v")) continue;
                        t.setValue(attValue);
                    }
                    way.addTag(t);
                }
            }
            NodeList nodeList = root.getElementsByTagName("node");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = new Node();
                stream.addNode(node);
                org.w3c.dom.Node nodeNode = nodeList.item(i);
                NamedNodeMap nodeAttributes = nodeNode.getAttributes();
                for (int a = 0; a < nodeAttributes.getLength(); ++a) {
                    org.w3c.dom.Node theAttribute = nodeAttributes.item(a);
                    String attName = theAttribute.getNodeName();
                    String attValue = theAttribute.getNodeValue();
                    if (attName != null && attName.equals("id")) {
                        node.setId(Integer.parseInt(attValue));
                    }
                    if (attName != null && attName.equals("lat")) {
                        node.setLat(attValue);
                    }
                    if (attName == null || !attName.equals("lon")) continue;
                    node.setLon(attValue);
                }
            }
            NodeList relationList = root.getElementsByTagName("relation");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stream;
    }

    public Stream streamTile(int x, int y, int zoom) {
        Stream stream = new Stream();
        try {
            double longLeft = MapUtil.tile2long(x, zoom);
            double longRight = MapUtil.tile2long(x + 1, zoom);
            double latNorth = MapUtil.tile2lat(y, zoom);
            double latSouth = MapUtil.tile2lat(y + 1, zoom);
            String bounding = "bbox=" + Double.toString(longLeft) + "," + Double.toString(latSouth) + "," + Double.toString(longRight) + "," + Double.toString(latNorth);
            String url = "http://api.openstreetmap.org/api/0.6/map?" + bounding;
            URL load = new URL(url);
            this.document = this.templateBuilder.parse(load.openStream());
            System.out.println("READ TILE STREAM [" + x + ";" + y + "]" + url);
            Element root = this.document.getDocumentElement();
            NodeList wayList = root.getElementsByTagName("way");
            for (int i = 0; i < wayList.getLength(); ++i) {
                org.w3c.dom.Node wayNode = wayList.item(i);
                Way way = new Way();
                stream.addWay(way);
                NamedNodeMap wayAttributes = wayNode.getAttributes();
                for (int a = 0; a < wayAttributes.getLength(); ++a) {
                    org.w3c.dom.Node theAttribute = wayAttributes.item(a);
                    String attName = theAttribute.getNodeName();
                    String attValue = theAttribute.getNodeValue();
                    if (attName != null && attName.equals("id")) {
                        way.setId(Integer.parseInt(attValue));
                    }
                    if (attName != null && attName.equals("timestamp")) {
                        way.setTimestamp(attValue);
                    }
                    if (attName == null || !attName.equals("user")) continue;
                    way.setUser(attValue);
                }
                NodeList nodeWayList = wayNode.getChildNodes();
                for (int j = 0; j < nodeWayList.getLength(); ++j) {
                    NamedNodeMap childAttributes;
                    org.w3c.dom.Node wayChild = nodeWayList.item(j);
                    String nodeName = wayChild.getNodeName();
                    if (nodeName.equals("nd")) {
                        childAttributes = wayChild.getAttributes();
                        for (int a = 0; a < childAttributes.getLength(); ++a) {
                            org.w3c.dom.Node theAttribute = childAttributes.item(a);
                            String attName = theAttribute.getNodeName();
                            String attValue = theAttribute.getNodeValue();
                            if (attName == null || !attName.equals("ref")) continue;
                            way.addNodeRef(Integer.parseInt(attValue));
                        }
                        continue;
                    }
                    if (!nodeName.equals("tag")) continue;
                    childAttributes = wayChild.getAttributes();
                    Tag t = new Tag();
                    for (int a = 0; a < childAttributes.getLength(); ++a) {
                        org.w3c.dom.Node theAttribute = childAttributes.item(a);
                        String attName = theAttribute.getNodeName();
                        String attValue = theAttribute.getNodeValue();
                        if (attName != null && attName.equals("k")) {
                            t.setKey(attValue);
                        }
                        if (attName == null || !attName.equals("v")) continue;
                        t.setValue(attValue);
                    }
                    way.addTag(t);
                }
            }
            NodeList nodeList = root.getElementsByTagName("node");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = new Node();
                stream.addNode(node);
                org.w3c.dom.Node nodeNode = nodeList.item(i);
                NamedNodeMap nodeAttributes = nodeNode.getAttributes();
                for (int a = 0; a < nodeAttributes.getLength(); ++a) {
                    org.w3c.dom.Node theAttribute = nodeAttributes.item(a);
                    String attName = theAttribute.getNodeName();
                    String attValue = theAttribute.getNodeValue();
                    if (attName != null && attName.equals("id")) {
                        node.setId(Integer.parseInt(attValue));
                    }
                    if (attName != null && attName.equals("lat")) {
                        node.setLat(attValue);
                    }
                    if (attName == null || !attName.equals("lon")) continue;
                    node.setLon(attValue);
                }
            }
            NodeList relationList = root.getElementsByTagName("relation");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stream;
    }

    public static void main(String[] args) {
        OSMRestBridgeEngine rendering = new OSMRestBridgeEngine();
        rendering.start();
    }
}

