/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.palette;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InputFonts {
    public static String ELEMENT = "Elements.ttf";
    public static String NEUROPOL = "NEUROPOL.ttf";
    public static String NO_MOVE = "No-move.ttf";
    private static String[] names = new String[]{ELEMENT, NEUROPOL, NO_MOVE};
    private static Map<String, Font> cache = new ConcurrentHashMap<String, Font>(names.length);

    public static Font getFont(String name, float size) {
        Font font = null;
        if (cache != null && (font = cache.get(name)) != null) {
            return font.deriveFont(size);
        }
        String fName = "font/" + name;
        try {
            InputStream is = InputFonts.class.getResourceAsStream(fName);
            font = Font.createFont(0, is);
            cache.put(name, font);
        }
        catch (Exception ex) {
            System.err.println(fName + " not loaded.  Using Dialog");
            font = new Font("Dialog", 0, 12);
        }
        return font;
    }

    private static Font getFont(String name) {
        Font font = null;
        if (cache != null && (font = cache.get(name)) != null) {
            return font;
        }
        String fName = "font/" + name;
        try {
            InputStream is = InputFonts.class.getResourceAsStream(fName);
            font = Font.createFont(0, is);
            cache.put(name, font);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(font);
        }
        catch (Exception ex) {
            System.err.println(fName + " not loaded.   Using Dialog");
            font = new Font("Dialog", 0, 12);
        }
        return font;
    }

    static {
        for (String name : names) {
            cache.put(name, InputFonts.getFont(name));
        }
    }
}

