/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.palette;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class TexturePalette {
    public static TexturePaint getTriangleCarbonFiber() {
        int width = 10;
        int height = 10;
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2d = bi.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHints(hints);
        g2d.setColor(Color.DARK_GRAY);
        g2d.fillRect(0, 0, width, height);
        Polygon p1 = new Polygon();
        p1.addPoint(width / 2, 0);
        p1.addPoint(width / 2, height);
        p1.addPoint(0, height / 2);
        Polygon p2 = new Polygon();
        p2.addPoint(width / 2, 0);
        p2.addPoint(width, 0);
        p2.addPoint(width, height / 2);
        Polygon p3 = new Polygon();
        p3.addPoint(width, height / 2);
        p3.addPoint(width, height);
        p3.addPoint(width / 2, height);
        g2d.setColor(Color.BLACK);
        g2d.fill(p1);
        g2d.fill(p2);
        g2d.fill(p3);
        Rectangle r = new Rectangle(0, 0, width, height);
        g2d.dispose();
        return new TexturePaint(bi, r);
    }

    public static TexturePaint getSquareCarbonFiber() {
        int width = 120;
        int height = 120;
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g2d = bi.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHints(hints);
        g2d.setColor(new Color(60, 60, 60));
        g2d.fillRect(0, 0, width, height);
        int w = 10;
        int h = 10;
        int x = 0;
        for (int i = -110; i < 200; i += 2 * h) {
            int y = i;
            x = -w / 2;
            for (int j = 0; j < 30; ++j) {
                Rectangle2D.Double rect1 = new Rectangle2D.Double(x, y, w, h);
                Point2D.Float start1 = new Point2D.Float(x + w / 2, y);
                Point2D.Float end1 = new Point2D.Float(x + w / 2, y + h);
                float[] dist1 = new float[]{0.0f, 1.0f};
                Color[] colors1 = new Color[]{Color.BLACK, Color.DARK_GRAY};
                LinearGradientPaint p1 = new LinearGradientPaint(start1, end1, dist1, colors1);
                g2d.setPaint(p1);
                g2d.fill(rect1);
                Rectangle2D.Double rect0 = new Rectangle2D.Double(x, y, w, h / 2);
                Point2D.Float start0 = new Point2D.Float(x, y / 4);
                Point2D.Float end0 = new Point2D.Float(x + w, y / 4);
                float[] dist0 = new float[]{0.0f, 1.0f};
                Color[] colors0 = new Color[]{Color.BLACK, Color.DARK_GRAY};
                LinearGradientPaint p0 = new LinearGradientPaint(start0, end0, dist0, colors0);
                g2d.setPaint(p0);
                g2d.fill(rect0);
                x += w / 2;
                y += h / 2;
            }
        }
        Rectangle r = new Rectangle(0, 0, width, height);
        g2d.dispose();
        return new TexturePaint(bi, r);
    }

    public static TexturePaint getPerforatedCircleSurface() {
        int width = 6;
        int height = 6;
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2d = bi.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHints(hints);
        g2d.setColor(Color.DARK_GRAY);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(Color.BLACK);
        Ellipse2D.Double e2D = new Ellipse2D.Double(width / 8, height / 8, 6 * width / 8, 6 * height / 8);
        g2d.fill(e2D);
        Rectangle r = new Rectangle(0, 0, width, height);
        g2d.dispose();
        return new TexturePaint(bi, r);
    }

    public static TexturePaint getPerforatedPolygonSurface() {
        int width = 8;
        int height = 8;
        int centerX = width / 2;
        int centerY = height / 2;
        double totalDegree = 360.0;
        float radius = new Float(width).floatValue() / 2.0f - new Float(width).floatValue() / 8.0f;
        double count = 6.0;
        double startAngleDegree = 0.0;
        double angleDegree = totalDegree / count;
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2d = bi.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHints(hints);
        g2d.setColor(Color.DARK_GRAY);
        g2d.fillRect(0, 0, width, height);
        GeneralPath path = new GeneralPath();
        int i = 0;
        while ((double)i < count) {
            double angle = startAngleDegree + (double)i * angleDegree;
            double px = (double)centerX + (double)radius * Math.cos(Math.toRadians(angle));
            double py = (double)centerY - (double)radius * Math.sin(Math.toRadians(angle));
            if (i == 0) {
                path.moveTo(px, py);
            } else {
                path.lineTo(px, py);
            }
            ++i;
        }
        path.closePath();
        g2d.setColor(Color.black);
        g2d.fill(path);
        Rectangle r = new Rectangle(0, 0, width, height);
        g2d.dispose();
        return new TexturePaint(bi, r);
    }

    public static TexturePaint getBeeCarbonTexture0() {
        return TexturePalette.getBeeCarbonTexture1Base(6.0f);
    }

    public static TexturePaint getBeeCarbonTexture1() {
        return TexturePalette.getBeeCarbonTexture1Base(4.0f);
    }

    private static TexturePaint getBeeCarbonTexture1Base(float radius) {
        int width = (int)((double)(2.0f * radius) * Math.sqrt(3.0));
        int height = (int)(2.0f * radius);
        radius -= radius / 6.0f;
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2d = bi.createGraphics();
        g2d.setColor(new Color(84, 84, 92));
        g2d.fillRect(0, 0, width, height);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHints(hints);
        Point2D.Double centerTopLeft = new Point2D.Double(0.0, 0.0);
        Point2D.Double centerTopRight = new Point2D.Double(width, 0.0);
        Point2D.Double centerCenter = new Point2D.Double(width / 2, height / 2);
        Point2D.Double centerBottomLeft = new Point2D.Double(0.0, height);
        Point2D.Double centerBottomRight = new Point2D.Double(width, height);
        Point2D[] centers = new Point2D[]{centerTopLeft, centerTopRight, centerCenter, centerBottomLeft, centerBottomRight};
        for (int i = 0; i < centers.length; ++i) {
            GeneralPath path = new GeneralPath();
            double angle = 0.0;
            for (int j = 0; j <= 5; ++j) {
                double px = centers[i].getX() + (double)radius * Math.cos(angle);
                double py = centers[i].getY() - (double)radius * Math.sin(angle);
                if (angle == 0.0) {
                    path.moveTo(px, py);
                } else {
                    path.lineTo(px, py);
                }
                angle += 1.0471975511965976;
            }
            path.closePath();
            Point2D.Double center = new Point2D.Double(centers[i].getX(), centers[i].getY());
            float focusRadius = radius + radius / 3.0f;
            Point2D.Double focus = new Point2D.Double(centers[i].getX(), centers[i].getY() + 10.0);
            float[] dist = new float[]{0.0f, 0.8f, 1.0f};
            Color[] colors = new Color[]{new Color(71, 72, 77), new Color(46, 47, 49), new Color(21, 22, 26).darker()};
            RadialGradientPaint p = new RadialGradientPaint(center, focusRadius, focus, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
            g2d.setPaint(p);
            g2d.fill(path);
            Point2D.Double start = new Point2D.Double(centers[i].getX(), centers[i].getY() - (double)radius);
            Point2D.Double end = new Point2D.Double(centers[i].getX(), centers[i].getY() + (double)radius);
            float[] dist2 = new float[]{0.0f, 0.2f, 0.3f, 1.0f};
            Color[] colors2 = new Color[]{new Color(0, 0, 0, 255), new Color(0, 0, 0, 200), new Color(0, 0, 0, 0), new Color(0, 0, 0, 0)};
            LinearGradientPaint lgp = new LinearGradientPaint(start, end, dist2, colors2);
            g2d.setPaint(lgp);
            g2d.fill(path);
        }
        Rectangle r = new Rectangle(0, 0, width, height);
        g2d.dispose();
        return new TexturePaint(bi, r);
    }

    public static TexturePaint getBeeCarbonTexture2() {
        return TexturePalette.getBeeCarbonTexture2Base(4.0f);
    }

    public static TexturePaint getBeeCarbonTexture3() {
        return TexturePalette.getBeeCarbonTexture2Base(6.0f);
    }

    private static TexturePaint getBeeCarbonTexture2Base(float radius) {
        int width = (int)((double)(2.0f * radius) * Math.sqrt(3.0));
        int height = (int)(2.0f * radius);
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2d = bi.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHints(hints);
        g2d.setColor(new Color(84, 84, 92));
        g2d.fillRect(0, 0, width, height);
        Point2D.Double centerTopLeft = new Point2D.Double(0.0, 0.0);
        Point2D.Double centerTopRight = new Point2D.Double(width, 0.0);
        Point2D.Double centerCenter = new Point2D.Double(width / 2, height / 2);
        Point2D.Double centerBottomLeft = new Point2D.Double(0.0, height);
        Point2D.Double centerBottomRight = new Point2D.Double(width, height);
        Point2D[] centers = new Point2D[]{centerTopLeft, centerTopRight, centerCenter, centerBottomLeft, centerBottomRight};
        for (int i = 0; i < centers.length; ++i) {
            GeneralPath path = new GeneralPath();
            double angle = 0.0;
            for (int j = 0; j <= 5; ++j) {
                double px = centers[i].getX() + (double)radius * Math.cos(angle);
                double py = centers[i].getY() - (double)radius * Math.sin(angle);
                if (angle == 0.0) {
                    path.moveTo(px, py);
                } else {
                    path.lineTo(px, py);
                }
                angle += 1.0471975511965976;
            }
            path.closePath();
            Point2D.Double center = new Point2D.Double(centers[i].getX(), centers[i].getY());
            float focusRadius = radius - radius / 3.0f;
            Point2D.Double focus = new Point2D.Double(centers[i].getX() + (double)radius - (double)(radius / 3.0f), centers[i].getY() + (double)radius - (double)(radius / 3.0f));
            float[] dist = new float[]{0.0f, 0.2f, 1.0f};
            Color[] colors = new Color[]{Color.GRAY, Color.DARK_GRAY, Color.BLACK};
            RadialGradientPaint p = new RadialGradientPaint(center, focusRadius, focus, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
            g2d.setPaint(p);
            g2d.fill(path);
        }
        Rectangle r = new Rectangle(0, 0, width, height);
        g2d.dispose();
        return new TexturePaint(bi, r);
    }

    public static TexturePaint getInterlacedCarbon1() {
        Color vstart = new Color(71, 72, 76);
        Color vend = new Color(21, 22, 26);
        return TexturePalette.getInterlacedCarbonTextureBase(5.0, vstart, vend, vstart, vend);
    }

    public static TexturePaint getInterlacedCarbon2() {
        Color vstart = new Color(71, 72, 76);
        Color vend = new Color(21, 22, 26);
        return TexturePalette.getInterlacedCarbonTextureBase(10.0, vstart, vend, vstart, vend);
    }

    public static TexturePaint getInterlacedCarbon(double thicknessPattern) {
        Color vstart = new Color(71, 72, 76);
        Color vend = new Color(21, 22, 26);
        return TexturePalette.getInterlacedCarbonTextureBase(thicknessPattern, vstart, vend, vstart, vend);
    }

    public static TexturePaint getInterlacedCarbonTextureBase(double thicknessPattern, Color hstart, Color hend, Color vstart, Color vend) {
        int width = (int)(4.0 * thicknessPattern);
        int height = (int)(4.0 * thicknessPattern);
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2d = bi.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHints(hints);
        TexturePalette.paintHInterlacedFiber(g2d, thicknessPattern, -thicknessPattern, 0.0, hstart, hend);
        TexturePalette.paintHInterlacedFiber(g2d, thicknessPattern, 0.0, 3.0 * thicknessPattern, hstart, hend);
        TexturePalette.paintHInterlacedFiber(g2d, thicknessPattern, thicknessPattern, 2.0 * thicknessPattern, hstart, hend);
        TexturePalette.paintHInterlacedFiber(g2d, thicknessPattern, 2.0 * thicknessPattern, thicknessPattern, hstart, hend);
        TexturePalette.paintHInterlacedFiber(g2d, thicknessPattern, 3.0 * thicknessPattern, 0.0, hstart, hend);
        TexturePalette.paintVInterlacedFiber(g2d, thicknessPattern, 0.0, thicknessPattern, vstart, vend);
        TexturePalette.paintVInterlacedFiber(g2d, thicknessPattern, thicknessPattern, 0.0, vstart, vend);
        TexturePalette.paintVInterlacedFiber(g2d, thicknessPattern, 2.0 * thicknessPattern, -thicknessPattern, vstart, vend);
        TexturePalette.paintVInterlacedFiber(g2d, thicknessPattern, 2.0 * thicknessPattern, 3.0 * thicknessPattern, vstart, vend);
        TexturePalette.paintVInterlacedFiber(g2d, thicknessPattern, 3.0 * thicknessPattern, 2.0 * thicknessPattern, vstart, vend);
        Rectangle model = new Rectangle(0, 0, width, height);
        g2d.dispose();
        return new TexturePaint(bi, model);
    }

    private static void paintHInterlacedFiber(Graphics2D g2d, double thicknessPattern, double px, double py, Color start, Color end) {
        double hw = 2.0 * thicknessPattern;
        double hh = thicknessPattern;
        Rectangle2D.Double r = new Rectangle2D.Double(px, py, hw, hh);
        LinearGradientPaint p = new LinearGradientPaint(new Point2D.Double(px, py), new Point2D.Double(px + 2.0 * thicknessPattern, py), new float[]{0.0f, 1.0f}, new Color[]{start, end});
        g2d.setPaint(p);
        g2d.fill(r);
    }

    private static void paintVInterlacedFiber(Graphics2D g2d, double thicknessPattern, double px, double py, Color start, Color end) {
        double vw = thicknessPattern;
        double vh = 2.0 * thicknessPattern;
        Rectangle2D.Double r = new Rectangle2D.Double(px, py, vw, vh);
        LinearGradientPaint p = new LinearGradientPaint(new Point2D.Double(px, py), new Point2D.Double(px, py + 2.0 * thicknessPattern), new float[]{0.0f, 1.0f}, new Color[]{start, end});
        g2d.setPaint(p);
        g2d.fill(r);
    }
}

