/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.palette;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.catalog.ui.ViewFrameUI;
import org.jensoft.core.palette.TexturePalette;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class TextureTest
extends View {
    private static final long serialVersionUID = -2875434568800741512L;
    private int rowCount = 5;
    private int colCount = 2;
    private Projection w = new Projection.Linear(-1.0, 1.0, -1.0, 1.0);

    public TextureTest() {
        this.registerProjection(this.w);
        AbstractPlugin plugin = new AbstractPlugin(){

            @Override
            protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
                if (viewPart == ViewPart.Device) {
                    TextureTest.this.paintCell(g2d, TexturePalette.getBeeCarbonTexture0(), 0, 0);
                    TextureTest.this.paintCell(g2d, TexturePalette.getBeeCarbonTexture1(), 0, 1);
                    TextureTest.this.paintCell(g2d, TexturePalette.getBeeCarbonTexture2(), 1, 0);
                    TextureTest.this.paintCell(g2d, TexturePalette.getBeeCarbonTexture3(), 1, 1);
                    TextureTest.this.paintCell(g2d, TexturePalette.getPerforatedCircleSurface(), 2, 0);
                    TextureTest.this.paintCell(g2d, TexturePalette.getPerforatedPolygonSurface(), 2, 1);
                    TextureTest.this.paintCell(g2d, TexturePalette.getSquareCarbonFiber(), 3, 0);
                    TextureTest.this.paintCell(g2d, TexturePalette.getTriangleCarbonFiber(), 3, 1);
                    TextureTest.this.paintCell(g2d, TexturePalette.getInterlacedCarbon1(), 4, 0);
                    TextureTest.this.paintCell(g2d, TexturePalette.getInterlacedCarbon2(), 4, 1);
                }
            }
        };
        this.w.registerPlugin(plugin);
    }

    private void paintCell(Graphics2D g2d, Paint texture, int row, int col) {
        double cellWidth = this.w.getDevice2D().getDeviceWidth() / this.colCount;
        double cellHeight = this.w.getDevice2D().getDeviceHeight() / this.rowCount;
        double px = (double)col * cellWidth;
        double py = (double)row * cellHeight;
        Rectangle2D.Double rect = new Rectangle2D.Double(px, py, cellWidth, cellHeight);
        g2d.setPaint(texture);
        g2d.fill(rect);
    }

    public static void main(String[] args) {
        ViewFrameUI ui = new ViewFrameUI(new TextureTest());
    }
}

