/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.palette.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class ColorPalette {
    public static Color WHITE = Color.WHITE;
    public static Color BLACK = Color.BLACK;
    public static Color DARK_GRAY = Color.DARK_GRAY;
    public static Color GRAY = Color.GRAY;
    public static Color LIGHT_GRAY = Color.LIGHT_GRAY;
    private static Random random = new Random();
    private int curentColor = 0;
    private List<Color> palette = new ArrayList<Color>();

    public static Color getRandomColor() {
        Color themeColor = new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255));
        return themeColor;
    }

    public static Color alpha(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static Color brighter(Color c, float factor) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = (int)(1.0 / (1.0 - (double)factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / factor), 255), Math.min((int)((float)g / factor), 255), Math.min((int)((float)b / factor), 255));
    }

    public static int getRed(Color color) {
        return color.getRed();
    }

    public static int getGreen(Color color) {
        return color.getGreen();
    }

    public static int getBlue(Color color) {
        return color.getBlue();
    }

    public static Color darker(Color c, float factor) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return new Color(Math.max((int)((float)r * factor), 0), Math.max((int)((float)g * factor), 0), Math.max((int)((float)b * factor), 0));
    }

    public void registerColor(Color color) {
        this.palette.add(color);
    }

    public Color getPaletteRandomColor() {
        return this.palette.get(random.nextInt(this.palette.size()));
    }

    public List<Color> getPaletteColors() {
        return this.palette;
    }

    public Color getColor(int index) {
        return this.palette.get(index);
    }

    public Color nextColor() {
        if (this.curentColor++ >= this.palette.size() - 1) {
            this.curentColor = 0;
        }
        return this.palette.get(this.curentColor);
    }

    public Color previousColor() {
        if (this.curentColor-- == 0) {
            this.curentColor = this.palette.size() - 1;
        }
        return this.palette.get(this.curentColor);
    }
}

