/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin;

import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class ClassSearchUtils {
    private static final Logger log = Logger.getAnonymousLogger();
    private ClassLoader classloader;
    private List<ClassPathEntry> list;
    private String extension;
    private String prefix;

    public static List<ClassPathEntry> searchClassPath(String prefix) {
        return ClassSearchUtils.searchClassPath(prefix, ".class");
    }

    public static List<ClassPathEntry> searchClassPath(String prefix, String extension) {
        ClassSearchUtils factory = new ClassSearchUtils();
        factory.prefix = prefix;
        return factory.find(extension);
    }

    private List<ClassPathEntry> find(String extension) {
        this.extension = extension;
        this.list = new ArrayList<ClassPathEntry>();
        this.classloader = this.getClass().getClassLoader();
        String classpath = System.getProperty("java.class.path");
        try {
            Method method = this.classloader.getClass().getMethod("getClassPath", new Class[]{null});
            if (method != null) {
                classpath = (String)method.invoke((Object)this.classloader, new Object[]{null});
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (classpath == null) {
            classpath = System.getProperty("java.class.path");
        }
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String name;
            String token = tokenizer.nextToken();
            File dir = new File(token);
            if (dir.isDirectory()) {
                this.lookInDirectory("", dir);
            }
            if (!dir.isFile() || !(name = dir.getName().toLowerCase()).endsWith(".zip") && !name.endsWith(".jar")) continue;
            this.lookInArchive(dir);
        }
        return this.list;
    }

    private void lookInDirectory(String name, File dir) {
        log.fine("Looking in directory [" + dir.getName() + "].");
        for (File file : dir.listFiles()) {
            String fileName;
            block8: {
                fileName = file.getName();
                if (file.isFile() && fileName.toLowerCase().endsWith(this.extension)) {
                    try {
                        ClassPathEntry entry;
                        if (this.extension.equalsIgnoreCase(".class")) {
                            fileName = fileName.substring(0, fileName.length() - 6);
                            if (!(name + fileName).startsWith(this.prefix)) continue;
                            log.fine("Found class: [" + name + fileName + "].");
                            entry = new ClassPathEntry(Class.forName(name + fileName), file);
                            this.list.add(entry);
                        } else {
                            entry = new ClassPathEntry(this.classloader.getResource(name.replace('.', File.separatorChar) + fileName), file);
                            this.list.add(entry);
                        }
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (NoClassDefFoundError e) {
                    }
                    catch (ExceptionInInitializerError e) {
                        if (e.getCause() instanceof HeadlessException) break block8;
                        throw e;
                    }
                }
            }
            if (!file.isDirectory()) continue;
            this.lookInDirectory(name + fileName + ".", file);
        }
    }

    private void lookInArchive(File archive) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(archive);
        }
        catch (IOException e) {
            log.warning("Non fatal error. Unable to read jar item.");
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.toLowerCase().endsWith(this.extension)) continue;
            try {
                ClassPathEntry classPathEntry;
                if (this.extension.equalsIgnoreCase(".class")) {
                    entryName = entryName.substring(0, entryName.length() - 6);
                    if (!(entryName = entryName.replace('/', '.')).startsWith(this.prefix)) continue;
                    log.fine("Found class: [" + entryName + "]. ");
                    classPathEntry = new ClassPathEntry(Class.forName(entryName), archive);
                    this.list.add(classPathEntry);
                    continue;
                }
                classPathEntry = new ClassPathEntry(this.classloader.getResource(entryName), archive);
                this.list.add(classPathEntry);
                log.fine("Found appropriate resource with name [" + entryName + "]. Resource instance:" + this.classloader.getResource(entryName));
            }
            catch (Throwable e) {
                log.warning("Unable to load resource [" + entryName + "] form file [" + archive.getAbsolutePath() + "].");
            }
        }
    }

    public static class ClassPathEntry {
        public Object entry;
        public File entryFile;

        public ClassPathEntry(Object entry, File classFile) {
            this.entry = entry;
            this.entryFile = classFile;
        }
    }
}

