/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.background;

import java.awt.Graphics2D;
import java.awt.Image;
import org.jensoft.core.device.DevicePartComponent;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class DeviceImageBackgroundPlugin
extends AbstractPlugin {
    private Image deviceImage;
    private boolean rescale = true;

    public DeviceImageBackgroundPlugin(Image deviceImage) {
        this.setName("BackgroundPlugin");
        this.deviceImage = deviceImage;
        this.setPriority(-10000);
    }

    public Image getDeviceImage() {
        return this.deviceImage;
    }

    public void setDeviceImage(Image deviceImage) {
        this.deviceImage = deviceImage;
    }

    public boolean isRescale() {
        return this.rescale;
    }

    public void setRescale(boolean rescale) {
        this.rescale = rescale;
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        DevicePartComponent d2d = view.getDevice2D();
        if (this.rescale) {
            g2d.drawImage(this.deviceImage, 0, 0, d2d.getDeviceWidth(), d2d.getDeviceHeight(), null);
        } else {
            g2d.drawImage(this.deviceImage, d2d.getDeviceWidth() / 2 - this.deviceImage.getWidth(null) / 2, d2d.getDeviceHeight() / 2 - this.deviceImage.getHeight(null) / 2, null);
        }
    }
}

