/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.background;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class DeviceTextureBackgroundPlugin
extends AbstractPlugin {
    private TexturePaint texture;
    private float textureAlpha = 1.0f;

    public DeviceTextureBackgroundPlugin(TexturePaint texture) {
        this.texture = texture;
    }

    public TexturePaint getTexture() {
        return this.texture;
    }

    public void setTexture(TexturePaint texture) {
        this.texture = texture;
    }

    public float getTextureAlpha() {
        return this.textureAlpha;
    }

    public void setTextureAlpha(float textureAlpha) {
        this.textureAlpha = textureAlpha;
    }

    @Override
    public void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        JComponent comp = view.getViewPartComponent(viewPart);
        Rectangle2D.Double device = new Rectangle2D.Double(0.0, 0.0, comp.getWidth(), comp.getHeight());
        g2d.setComposite(AlphaComposite.getInstance(3, this.textureAlpha));
        g2d.setPaint(this.texture);
        g2d.fill(device);
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }
}

