/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.bubble;

import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.bubble.Bubble;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class BubblePlugin
extends AbstractPlugin {
    private List<Bubble> bubbles;

    public BubblePlugin() {
        this.setName("BubblePlugin");
        this.setPriority(100);
        this.bubbles = new ArrayList<Bubble>();
        this.setAntialiasing(Antialiasing.On);
    }

    public void addBubble(Bubble bubble) {
        bubble.setHost(this);
        this.bubbles.add(bubble);
    }

    public void removeBubble(Bubble bubble) {
        this.bubbles.remove(bubble);
    }

    private void paintBubble(View v2d, Graphics2D g2d, Bubble bubble) {
        if (bubble.getBubbleFill() != null) {
            bubble.getBubbleFill().paintBubble(g2d, bubble);
        }
        if (bubble.getBubbleDraw() != null) {
            bubble.getBubbleDraw().paintBubble(g2d, bubble);
        }
        if (bubble.getBubbleEffect() != null) {
            bubble.getBubbleEffect().paintBubble(g2d, bubble);
        }
    }

    private void solveGeometry() {
        for (Bubble bubble : this.bubbles) {
            Point2D.Double p2dUserCenter = new Point2D.Double(bubble.getX(), bubble.getY());
            Point2D p2dDeviceCenter = bubble.getHost().getProjection().userToPixel(p2dUserCenter);
            Ellipse2D.Double bubbleShape = new Ellipse2D.Double(p2dDeviceCenter.getX() - bubble.getRadius(), p2dDeviceCenter.getY() - bubble.getRadius(), 2.0 * bubble.getRadius(), 2.0 * bubble.getRadius());
            bubble.setBubbleShape(bubbleShape);
        }
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        this.solveGeometry();
        for (Bubble bubble : this.bubbles) {
            this.paintBubble(view, g2d, bubble);
        }
    }
}

