/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.bubble.painter.fill;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.bubble.Bubble;
import org.jensoft.core.plugin.bubble.painter.BubbleFill;

public class BubbleFill1
extends BubbleFill {
    private Color startColor;
    private Color endColor;
    private int incidenceAngleDegree = 90;
    private float[] shadeFractions;
    private Color[] shadeColors;

    public BubbleFill1(Color startColor, Color endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
    }

    public BubbleFill1(Color startColor, Color endColor, int incidenceAngleDegree) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public BubbleFill1(float[] shadeFractions, Color[] shadeColors) {
        this.shadeFractions = shadeFractions;
        this.shadeColors = shadeColors;
    }

    public BubbleFill1(float[] shadeFractions, Color[] shadeColors, int incidenceAngleDegree) {
        this.shadeFractions = shadeFractions;
        this.shadeColors = shadeColors;
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }

    @Override
    public void paintBubble(Graphics2D g2d, Bubble bubble) {
        double endY;
        double endX;
        Point2D.Double end;
        double startY;
        double centerX = bubble.getX();
        double centerY = bubble.getY();
        double radius = bubble.getRadius();
        double startX = centerX + radius * Math.cos(Math.toRadians(this.incidenceAngleDegree));
        Point2D.Double start = new Point2D.Double(startX, startY = centerY - radius * Math.sin(Math.toRadians(this.incidenceAngleDegree)));
        if (start.equals(end = new Point2D.Double(endX = centerX + radius * Math.cos(Math.toRadians(this.incidenceAngleDegree + 180)), endY = centerY - radius * Math.sin(Math.toRadians(this.incidenceAngleDegree + 180))))) {
            return;
        }
        Color[] colors = null;
        float[] fractions = null;
        if (this.startColor != null && this.endColor != null) {
            Color[] scolor = new Color[]{this.startColor, this.endColor};
            float[] sfractions = new float[]{0.0f, 1.0f};
            colors = scolor;
            fractions = sfractions;
        }
        if (this.shadeFractions != null && this.shadeColors != null) {
            colors = this.shadeColors;
            fractions = this.shadeFractions;
        }
        if (fractions != null && colors != null) {
            LinearGradientPaint p = new LinearGradientPaint(start, end, fractions, colors);
            g2d.setPaint(p);
            g2d.fill(bubble.getBubbleShape());
        }
    }
}

