/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.capacity;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Fractional;
import org.jensoft.core.palette.color.Alpha;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.capacity.CapacityCell;
import org.jensoft.core.plugin.capacity.CapacityUnit;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class CapacityPlugin
extends AbstractPlugin {
    private int col;
    private int row;
    private double cellWidth;
    private double cellHeight;
    private CapacityMode mode = CapacityMode.Horizontal;
    private List<CapacityUnit> units = new ArrayList<CapacityUnit>();

    public CapacityPlugin(int row, int col) {
        this.col = col;
        this.row = row;
        this.setFractionalMetrics(Fractional.On);
        this.setAntialiasing(Antialiasing.On);
    }

    public CapacityMode getMode() {
        return this.mode;
    }

    public void setMode(CapacityMode mode) {
        this.mode = mode;
    }

    public int getCol() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    public void registerCapacity(CapacityUnit capacityUnit) {
        int startIndex = 0;
        for (CapacityUnit unit : this.units) {
            int count = unit.getCount();
            startIndex += count;
        }
        if (startIndex + capacityUnit.getCount() > this.col * this.row) {
            throw new IllegalArgumentException("unit " + capacityUnit.getCount() + ", index out of total capacity. max capacity " + this.row * this.col + " cells, unit use index range [" + startIndex + "," + (startIndex + capacityUnit.getCount()) + "]");
        }
        capacityUnit.setHost(this);
        this.units.add(capacityUnit);
        this.createIndex();
    }

    private void paintUnit(Graphics2D g2d, CapacityUnit unit) {
        for (CapacityCell cell : unit.getCells()) {
            Point2D p2d = this.capacityToPixel(cell);
            Rectangle2D.Double cellUnit = new Rectangle2D.Double(p2d.getX(), p2d.getY(), this.cellWidth, this.cellHeight);
            g2d.setColor(new Alpha(unit.getColor(), 200));
            g2d.fill(cellUnit);
            g2d.setStroke(new BasicStroke(0.6f));
            g2d.setColor(new Alpha(unit.getColor().darker(), 200));
            g2d.draw(cellUnit);
        }
    }

    private Point2D capacityToPixel(CapacityCell cell) {
        Point2D.Double p2d = new Point2D.Double(new Double(cell.getColumn()) * this.cellWidth, new Double(cell.getRow()) * this.cellHeight);
        return p2d;
    }

    public int cellToVIndex(CapacityCell cell) {
        return (cell.getColumn() + 1) * this.row - 1;
    }

    public int cellToHIndex(CapacityCell cell) {
        return (cell.getRow() + 1) * this.col - 1;
    }

    private void createIndex() {
        int startIndex = 0;
        for (CapacityUnit unit : this.units) {
            int count = unit.getCount();
            unit.setStartIndex(startIndex);
            startIndex += count;
        }
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        int width = this.getProjection().getDevice2D().getDeviceWidth();
        int height = this.getProjection().getDevice2D().getDeviceHeight();
        this.cellWidth = new Double(width) / new Double(this.col);
        this.cellHeight = new Double(height) / new Double(this.row);
        this.createIndex();
        for (CapacityUnit unit : this.units) {
            unit.buildUnit();
            this.paintUnit(g2d, unit);
        }
    }

    public static enum CapacityMode {
        Horizontal,
        Vertical;

    }
}

