/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.capacity;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.capacity.CapacityCell;
import org.jensoft.core.plugin.capacity.CapacityPlugin;

public class CapacityUnit {
    private Color color;
    private CapacityPlugin host;
    private int startIndex;
    private int count = 0;
    private List<CapacityCell> cells = new ArrayList<CapacityCell>();

    public CapacityUnit(int count) {
        this.count = count;
    }

    public void buildUnit() {
        this.clearCells();
        for (int i = this.startIndex; i < this.startIndex + this.count; ++i) {
            if (this.getHost().getMode() == CapacityPlugin.CapacityMode.Horizontal) {
                this.cells.add(this.createCellByHorizontalIndex(i));
                continue;
            }
            this.cells.add(this.createCellByVerticalIndex(i));
        }
    }

    private CapacityCell createCellByVerticalIndex(int vIndex) {
        int[] rc = new int[]{vIndex / this.getHost().getRow(), vIndex % this.getHost().getRow()};
        return new CapacityCell(rc[1], rc[0]);
    }

    private CapacityCell createCellByHorizontalIndex(int hIndex) {
        int[] rc = new int[]{hIndex / this.getHost().getCol(), hIndex % this.getHost().getCol()};
        return new CapacityCell(rc[0], rc[1]);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setCells(List<CapacityCell> cells) {
        this.cells = cells;
    }

    public CapacityPlugin getHost() {
        return this.host;
    }

    public void setHost(CapacityPlugin host) {
        this.host = host;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void clearCells() {
        this.cells.clear();
    }

    public List<CapacityCell> getCells() {
        return this.cells;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

