/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d;

import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.donut2d.Donut2DListener;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.animator.AbstractDonut2DAnimator;
import org.jensoft.core.plugin.donut2d.painter.draw.AbstractDonut2DDraw;
import org.jensoft.core.plugin.donut2d.painter.effect.AbstractDonut2DEffect;
import org.jensoft.core.plugin.donut2d.painter.fill.AbstractDonut2DFill;
import org.jensoft.core.plugin.donut2d.painter.fill.Donut2DDefaultFill;

public class Donut2D {
    private String name;
    private Donut2DNature nature = Donut2DNature.Device;
    private double centerX;
    private double centerY;
    private double buildCenterX;
    private double buildCenterY;
    private double outerRadius;
    private double innerRadius;
    private double startAngleDegree = 0.0;
    private double explose = 0.0;
    private AbstractDonut2DDraw donut2DDraw;
    private AbstractDonut2DFill donut2DFill;
    private AbstractDonut2DEffect donut2DEffect;
    private List<Donut2DSlice> slices = new ArrayList<Donut2DSlice>();
    private AbstractPlugin hostPlugin;
    private EventListenerList donut2DListenerList;

    public Donut2D() {
        this.donut2DFill = new Donut2DDefaultFill();
        this.donut2DListenerList = new EventListenerList();
    }

    public void addDonut2DListener(Donut2DListener listener) {
        this.donut2DListenerList.add(Donut2DListener.class, listener);
    }

    public void removeDonut2DListener(Donut2DListener listener) {
        this.donut2DListenerList.remove(Donut2DListener.class, listener);
    }

    public EventListenerList getDonut2DListenerList() {
        return this.donut2DListenerList;
    }

    public void addDonutAnimator(AbstractDonut2DAnimator animator) {
        animator.setDonut2D(this);
        this.addDonut2DListener(animator);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Donut2DNature getNature() {
        return this.nature;
    }

    public void setNature(Donut2DNature nature) {
        this.nature = nature;
    }

    public AbstractPlugin getHostPlugin() {
        return this.hostPlugin;
    }

    public void setHostPlugin(AbstractPlugin host) {
        this.hostPlugin = host;
    }

    public AbstractDonut2DDraw getDonut2DDraw() {
        return this.donut2DDraw;
    }

    public void setDonut2DDraw(AbstractDonut2DDraw donut2dDraw) {
        this.donut2DDraw = donut2dDraw;
    }

    public AbstractDonut2DFill getDonut2DFill() {
        return this.donut2DFill;
    }

    public void setDonut2DFill(AbstractDonut2DFill donut2dFill) {
        this.donut2DFill = donut2dFill;
    }

    public AbstractDonut2DEffect getDonut2DEffect() {
        return this.donut2DEffect;
    }

    public void setDonut2DEffect(AbstractDonut2DEffect donut2dEffect) {
        this.donut2DEffect = donut2dEffect;
    }

    public void setAlpha(float alpha) {
        for (int i = 0; i < this.slices.size(); ++i) {
            Donut2DSlice s = this.slices.get(i);
            s.setAlpha(alpha);
        }
    }

    public void clearSlices() {
        this.slices.clear();
    }

    public int countSlice() {
        return this.slices.size();
    }

    public void setSlices(Vector<Donut2DSlice> slices) {
        this.slices = slices;
    }

    public Donut2DSlice getSlice(int index) {
        return this.slices.get(index);
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.centerX, this.centerY);
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double centerY) {
        this.centerY = centerY;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double outerRadius) {
        this.outerRadius = outerRadius;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double innerRadius) {
        this.innerRadius = innerRadius;
    }

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public double getExplose() {
        return this.explose;
    }

    public void setExplose(double explose) {
        this.explose = explose;
    }

    public void addSlice(Donut2DSlice slice) {
        slice.setHost(this);
        this.slices.add(slice);
    }

    private void sum() {
        Donut2DSlice s;
        int i;
        double sum = 0.0;
        for (i = 0; i < this.slices.size(); ++i) {
            s = this.slices.get(i);
            sum += s.getValue();
        }
        for (i = 0; i < this.slices.size(); ++i) {
            s = this.slices.get(i);
            double percent = s.getValue() / sum;
            s.setPercent(percent);
        }
    }

    public Area getDonut2DArea() {
        Area donut2DArea = new Area();
        for (Donut2DSlice slice : this.getSlices()) {
            donut2DArea.add(new Area(slice.getSlicePath()));
        }
        return donut2DArea;
    }

    private void projection() {
        if (this.getNature() == Donut2DNature.User) {
            Point2D center = this.getCenter();
            Point2D projectedCenter = this.getHostPlugin().getProjection().userToPixel(center);
            this.buildCenterX = (int)projectedCenter.getX();
            this.buildCenterY = (int)projectedCenter.getY();
        } else {
            this.buildCenterX = this.centerX;
            this.buildCenterY = this.centerY;
        }
    }

    public void solveGeometry() {
        this.projection();
        this.sum();
        for (int j = 0; j < this.slices.size(); ++j) {
            Donut2DSlice s = this.slices.get(j);
            this.buildSlice(s);
        }
    }

    private void buildSlice(Donut2DSlice slice) {
        double medianDegree;
        double deltaDegree = slice.getPercent() * 360.0 - this.explose;
        if (this.startAngleDegree > 360.0) {
            this.startAngleDegree -= 360.0;
        }
        if ((medianDegree = this.startAngleDegree + deltaDegree / 2.0) > 360.0) {
            medianDegree -= 360.0;
        }
        double sliceCenterX = this.buildCenterX + slice.getDivergence() * Math.cos(Math.toRadians(medianDegree));
        double sliceCenterY = this.buildCenterY - slice.getDivergence() * Math.sin(Math.toRadians(medianDegree));
        double cornerExternalX = sliceCenterX - this.getOuterRadius();
        double cornerExternalY = sliceCenterY - this.getOuterRadius();
        Arc2D.Double externalArc2D = new Arc2D.Double(cornerExternalX, cornerExternalY, 2.0 * this.getOuterRadius(), 2.0 * this.getOuterRadius(), this.startAngleDegree, deltaDegree, 0);
        slice.setOuterArc(externalArc2D);
        double cornerInternalX = sliceCenterX - this.getInnerRadius();
        double cornerInternalY = sliceCenterY - this.getInnerRadius();
        Arc2D.Double internalArc2D = new Arc2D.Double(cornerInternalX, cornerInternalY, 2.0 * this.getInnerRadius(), 2.0 * this.getInnerRadius(), this.startAngleDegree + deltaDegree, -deltaDegree, 0);
        slice.setInnerArc(internalArc2D);
        GeneralPath gp = new GeneralPath();
        gp.append(externalArc2D, false);
        gp.append(internalArc2D, true);
        gp.closePath();
        slice.setSlicePath(gp);
        Line2D.Double lineStart = new Line2D.Double(internalArc2D.getEndPoint(), externalArc2D.getStartPoint());
        Line2D.Double lineEnd = new Line2D.Double(externalArc2D.getEndPoint(), internalArc2D.getStartPoint());
        slice.setLineStart(lineStart);
        slice.setLineEnd(lineEnd);
        slice.setStartAngleDegree(this.startAngleDegree);
        slice.setEndAngleDegree(this.startAngleDegree + deltaDegree);
        this.startAngleDegree = this.startAngleDegree + deltaDegree + this.explose;
    }

    public List<Donut2DSlice> getSlices() {
        return this.slices;
    }

    public boolean isLockRollover() {
        for (int i = 0; i < this.slices.size(); ++i) {
            Donut2DSlice s = this.slices.get(i);
            if (!s.isLockRollover()) continue;
            return true;
        }
        return false;
    }

    public boolean isLockEnter() {
        for (int i = 0; i < this.slices.size(); ++i) {
            Donut2DSlice s = this.slices.get(i);
            if (!s.isLockEnter()) continue;
            return true;
        }
        return false;
    }

    public static enum Donut2DNature {
        User("user"),
        Device("device");

        private String nature;

        private Donut2DNature(String nature) {
            this.nature = nature;
        }

        public String getNature() {
            return this.nature;
        }

        public static Donut2DNature parseNature(String nature) {
            if (Device.getNature().equals(nature)) {
                return Device;
            }
            if (User.getNature().equals(nature)) {
                return User;
            }
            return Device;
        }
    }
}

