/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d;

import java.awt.Color;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.painter.draw.AbstractDonut2DSliceDraw;
import org.jensoft.core.plugin.donut2d.painter.effect.AbstractDonut2DSliceEffect;
import org.jensoft.core.plugin.donut2d.painter.fill.AbstractDonut2DSliceFill;
import org.jensoft.core.plugin.donut2d.painter.label.AbstractDonut2DSliceLabel;

public class Donut2DSlice {
    private String name;
    private double value;
    private double divergence;
    private double percent;
    private double startAngleDegree;
    private double endAngleDegree;
    private GeneralPath path;
    private Line2D lineStart;
    private Line2D lineEnd;
    private Arc2D outerArc;
    private Arc2D innerArc;
    private Color themeColor;
    private boolean lockRollover = false;
    private boolean lockPressed = false;
    private boolean lockEnter = false;
    private AbstractDonut2DSliceDraw sliceDraw;
    private AbstractDonut2DSliceFill sliceFill;
    private AbstractDonut2DSliceEffect sliceEffect;
    private List<AbstractDonut2DSliceLabel> sliceLabels;
    private Donut2D host;
    private float alpha = 1.0f;

    public Donut2DSlice(String name, Color themeColor) {
        this.name = name;
        this.themeColor = themeColor;
        this.sliceLabels = new ArrayList<AbstractDonut2DSliceLabel>();
    }

    public List<AbstractDonut2DSliceLabel> getSliceLabels() {
        return this.sliceLabels;
    }

    public void addSliceLabel(AbstractDonut2DSliceLabel sliceLabel) {
        this.sliceLabels.add(sliceLabel);
    }

    public void removeSliceLabel(AbstractDonut2DSliceLabel sliceLabel) {
        this.sliceLabels.remove(sliceLabel);
    }

    public boolean containsSliceLabel(AbstractDonut2DSliceLabel sliceLabel) {
        return this.sliceLabels.contains(sliceLabel);
    }

    public void removeAllSliceLabels() {
        this.sliceLabels.clear();
    }

    public Color getThemeColor() {
        return this.themeColor;
    }

    public void setThemeColor(Color colorTheme) {
        this.themeColor = colorTheme;
    }

    public Line2D getLineStart() {
        return this.lineStart;
    }

    public void setLineStart(Line2D lineStart) {
        this.lineStart = lineStart;
    }

    public Line2D getLineEnd() {
        return this.lineEnd;
    }

    public void setLineEnd(Line2D lineEnd) {
        this.lineEnd = lineEnd;
    }

    public Donut2D getHost() {
        return this.host;
    }

    public void setHost(Donut2D host) {
        this.host = host;
    }

    public double getDivergence() {
        return this.divergence;
    }

    public void setDivergence(double divergence) {
        this.divergence = divergence;
    }

    public void lockEnter() {
        this.lockEnter = true;
    }

    public void unlockEnter() {
        this.lockEnter = false;
    }

    public boolean isLockEnter() {
        return this.lockEnter;
    }

    public void lockRollover() {
        this.lockRollover = true;
    }

    public void unlockRollover() {
        this.lockRollover = false;
    }

    public boolean isLockRollover() {
        return this.lockRollover;
    }

    public void lockPressed() {
        this.lockPressed = true;
    }

    public void unlockPressed() {
        this.lockPressed = false;
    }

    public boolean isLockPressed() {
        return this.lockPressed;
    }

    public boolean contains(Point2D p2d) {
        if (this.path != null) {
            return this.path.contains(p2d);
        }
        return false;
    }

    public boolean intersects(Rectangle2D rect2D) {
        return this.path.intersects(rect2D);
    }

    public Arc2D getOuterArc() {
        return this.outerArc;
    }

    public void setOuterArc(Arc2D outerArc) {
        this.outerArc = outerArc;
    }

    public Arc2D getInnerArc() {
        return this.innerArc;
    }

    public void setInnerArc(Arc2D innerArc) {
        this.innerArc = innerArc;
    }

    public GeneralPath getSlicePath() {
        return this.path;
    }

    public void setSlicePath(GeneralPath path) {
        this.path = path;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getPercent() {
        return this.percent;
    }

    public void setPercent(double percent) {
        this.percent = percent;
    }

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public double getEndAngleDegree() {
        return this.endAngleDegree;
    }

    public void setEndAngleDegree(double endAngleDegree) {
        this.endAngleDegree = endAngleDegree;
    }

    public double getMedianAngleDegree() {
        return this.getStartAngleDegree() + this.getExtendsDegree() / 2.0;
    }

    public double getExtendsDegree() {
        return Math.abs(this.getEndAngleDegree() - this.getStartAngleDegree());
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("slice alpha out of range [0,1]");
        }
        this.alpha = alpha;
    }

    public void setSliceLabels(List<AbstractDonut2DSliceLabel> sliceLabels) {
        this.sliceLabels = sliceLabels;
    }

    public AbstractDonut2DSliceDraw getSliceDraw() {
        return this.sliceDraw;
    }

    public void setSliceDraw(AbstractDonut2DSliceDraw sliceDraw) {
        this.sliceDraw = sliceDraw;
    }

    public AbstractDonut2DSliceFill getSliceFill() {
        return this.sliceFill;
    }

    public void setSliceFill(AbstractDonut2DSliceFill sliceFill) {
        this.sliceFill = sliceFill;
    }

    public AbstractDonut2DSliceEffect getSliceEffect() {
        return this.sliceEffect;
    }

    public void setSliceEffect(AbstractDonut2DSliceEffect sliceEffect) {
        this.sliceEffect = sliceEffect;
    }
}

