/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.animator;

import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DEvent;
import org.jensoft.core.plugin.donut2d.Donut2DListener;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.view.View;

public abstract class AbstractDonut2DAnimator
implements Donut2DListener {
    private Donut2D donut2D;

    public Donut2D getDonut2D() {
        return this.donut2D;
    }

    public void setDonut2D(Donut2D donut2d) {
        this.donut2D = donut2d;
    }

    protected void onEntered(Donut2DSlice slice) {
    }

    protected void onExited(Donut2DSlice slice) {
    }

    protected void onClicked(Donut2DSlice slice) {
    }

    protected void onPressed(Donut2DSlice slice) {
    }

    protected void onReleased(Donut2DSlice slice) {
    }

    protected abstract Runnable getAnimator(Donut2DSlice var1);

    @Override
    public final void donut2DSliceClicked(Donut2DEvent e) {
        Donut2DSlice slice = e.getDonut2DSlice();
        this.onClicked(slice);
    }

    @Override
    public final void donut2DSlicePressed(Donut2DEvent e) {
        Donut2DSlice slice = e.getDonut2DSlice();
        this.onPressed(slice);
    }

    @Override
    public final void donut2DSliceReleased(Donut2DEvent e) {
        Donut2DSlice slice = e.getDonut2DSlice();
        this.onReleased(slice);
    }

    @Override
    public final void donut2DSliceEntered(Donut2DEvent e) {
        Donut2DSlice slice = e.getDonut2DSlice();
        this.onEntered(slice);
    }

    @Override
    public final void donut2DSliceExited(Donut2DEvent e) {
        Donut2DSlice slice = e.getDonut2DSlice();
        this.onExited(slice);
    }

    public View getView(Donut2DSlice slice) {
        return slice.getHost().getHostPlugin().getProjection().getView();
    }
}

