/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.painter.draw;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.List;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.painter.draw.AbstractDonut2DDraw;
import org.jensoft.core.plugin.donut2d.painter.draw.Donut2DSliceDefaultDraw;

public class Donut2DDefaultDraw
extends AbstractDonut2DDraw {
    private Color outlineColor;
    private Stroke stroke = new BasicStroke();
    private Donut2DSliceDefaultDraw sliceDraw = new Donut2DSliceDefaultDraw();

    public Donut2DDefaultDraw() {
    }

    public Donut2DDefaultDraw(Color outlineColor) {
        this();
        this.outlineColor = outlineColor;
        this.sliceDraw.setDrawColor(outlineColor);
    }

    public Donut2DDefaultDraw(Color outlineColor, Stroke stroke) {
        this();
        this.outlineColor = outlineColor;
        this.stroke = stroke;
        this.sliceDraw.setDrawColor(outlineColor);
        this.sliceDraw.setDrawStroke(stroke);
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    @Override
    public void paintDonut2DDraw(Graphics2D g2d, Donut2D donut2D) {
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        List<Donut2DSlice> sections = donut2D.getSlices();
        g2d.setStroke(new BasicStroke(2.0f));
        for (int j = 0; j < sections.size(); ++j) {
            Donut2DSlice s = sections.get(j);
            this.sliceDraw.paintDonut2DSlice(g2d, donut2D, s);
        }
    }
}

