/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.painter.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.painter.draw.AbstractDonut2DSliceDraw;

public class Donut2DSliceDefaultDraw
extends AbstractDonut2DSliceDraw {
    private Color drawColor;
    private Stroke drawStroke;
    private Stroke defaultStroke = new BasicStroke();

    public Donut2DSliceDefaultDraw() {
    }

    public Donut2DSliceDefaultDraw(Color drawColor, Stroke drawStroke) {
        this.drawColor = drawColor;
        this.drawStroke = drawStroke;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public Stroke getDrawStroke() {
        return this.drawStroke;
    }

    public void setDrawStroke(Stroke drawStroke) {
        this.drawStroke = drawStroke;
    }

    @Override
    protected final void paintDonut2DSliceDraw(Graphics2D g2d, Donut2D donut2D, Donut2DSlice slice) {
        if (this.drawColor != null) {
            g2d.setColor(this.drawColor);
        } else {
            g2d.setColor(slice.getThemeColor());
        }
        if (this.drawStroke != null) {
            g2d.setStroke(this.drawStroke);
        } else {
            g2d.setStroke(this.defaultStroke);
        }
        g2d.draw(slice.getSlicePath());
    }
}

