/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.painter.effect;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jensoft.core.graphics.ReflectionRenderer;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.painter.effect.AbstractDonut2DEffect;
import org.jensoft.core.plugin.donut2d.painter.effect.Donut2DCompoundEffect;

public class Donut2DReflectionEffect
extends AbstractDonut2DEffect {
    private float opacity = 0.5f;
    private float length = 0.3f;
    private boolean blurEnabled = true;
    private BufferedImage pieImage;
    private ReflectionRenderer renderer = new ReflectionRenderer();
    private BufferedImage reflection;

    public Donut2DReflectionEffect() {
        this.renderer.setOpacity(this.opacity);
        this.renderer.setLength(this.length);
        this.renderer.setBlurEnabled(this.blurEnabled);
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        if (opacity < 0.0f) {
            opacity = 0.0f;
        } else if (opacity > 1.0f) {
            opacity = 1.0f;
        }
        this.opacity = opacity;
        this.renderer.setOpacity(opacity);
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        if (length < 0.0f) {
            length = 0.0f;
        } else if (length > 1.0f) {
            length = 1.0f;
        }
        this.length = length;
        this.renderer.setLength(length);
    }

    public boolean isBlurEnabled() {
        return this.blurEnabled;
    }

    public void setBlurEnabled(boolean blurEnabled) {
        this.blurEnabled = blurEnabled;
        this.renderer.setBlurEnabled(blurEnabled);
    }

    @Override
    protected final void paintDonut2DEffect(Graphics2D g2d, Donut2D donut2D) {
        try {
            this.pieImage = this.getDonut2DImage(donut2D);
            this.reflection = this.renderer.createReflection(this.pieImage);
            Area a = donut2D.getDonut2DArea();
            Rectangle rect = a.getBounds();
            g2d.drawImage((Image)this.reflection, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()), null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public BufferedImage getDonut2DImage(Donut2D donut2D) {
        Area pieArea = donut2D.getDonut2DArea();
        Rectangle bound = pieArea.getBounds();
        int width = (int)bound.getWidth();
        int height = (int)bound.getHeight();
        BufferedImage pieImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = (Graphics2D)pieImage.getGraphics();
        donut2D.getHostPlugin().configureGraphics(g2d);
        g2d.translate(-((int)bound.getX()), -((int)bound.getY()));
        if (donut2D.getDonut2DFill() != null) {
            donut2D.getDonut2DFill().paintDonut2D(g2d, donut2D);
        }
        if (donut2D.getDonut2DDraw() != null) {
            donut2D.getDonut2DDraw().paintDonut2D(g2d, donut2D);
        }
        if (donut2D.getDonut2DEffect() != null) {
            if (!donut2D.getDonut2DEffect().equals(this) && !(donut2D.getDonut2DEffect() instanceof Donut2DCompoundEffect)) {
                donut2D.getDonut2DEffect().paintDonut2D(g2d, donut2D);
            }
            if (donut2D.getDonut2DEffect() instanceof Donut2DCompoundEffect) {
                Donut2DCompoundEffect compound = (Donut2DCompoundEffect)donut2D.getDonut2DEffect();
                AbstractDonut2DEffect[] effects = compound.getEffects();
                for (int i = 0; i < effects.length; ++i) {
                    if (effects[i].equals(this)) continue;
                    effects[i].paintDonut2D(g2d, donut2D);
                }
            }
        }
        List<Donut2DSlice> slices = donut2D.getSlices();
        for (Donut2DSlice slice : slices) {
            if (slice.getSliceFill() != null) {
                slice.getSliceFill().paintDonut2DSlice(g2d, donut2D, slice);
            }
            if (slice.getSliceDraw() != null) {
                slice.getSliceDraw().paintDonut2DSlice(g2d, donut2D, slice);
            }
            if (slice.getSliceEffect() == null || slice.getSliceEffect().equals(this)) continue;
            slice.getSliceEffect().paintDonut2DSlice(g2d, donut2D, slice);
        }
        return pieImage;
    }
}

