/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.painter.effect;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.painter.effect.AbstractDonut2DSliceEffect;

public class Donut2DSliceLinearEffect
extends AbstractDonut2DSliceEffect {
    private Color startColor;
    private Color endColor;
    private int offsetRadius = 3;
    private int incidenceAngleDegree = 90;
    private float[] shadeFractions;
    private Color[] shadeColors;
    private Color cStart = new Color(60, 60, 60, 180);
    private Color cEnd = new Color(255, 255, 255, 180);
    private float[] fractions = new float[]{0.0f, 0.49f, 0.51f, 1.0f};
    private Color[] colors = new Color[]{this.cStart, new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), this.cEnd};

    public Donut2DSliceLinearEffect() {
    }

    public Donut2DSliceLinearEffect(Color startColor, Color endColor, int offsetRadius) {
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.startColor = startColor;
        this.endColor = endColor;
        this.offsetRadius = offsetRadius;
    }

    public Donut2DSliceLinearEffect(Color startColor, Color endColor, int offsetRadius, int incidenceAngleDegree) {
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.startColor = startColor;
        this.endColor = endColor;
        this.offsetRadius = offsetRadius;
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public Donut2DSliceLinearEffect(Color startColor, Color endColor) {
        this(startColor, endColor, 0);
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Color startColor) {
        this.startColor = startColor;
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setEndColor(Color endColor) {
        this.endColor = endColor;
    }

    public int getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(int offsetRadius) {
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.offsetRadius = offsetRadius;
    }

    public int getIncidenceAngleDegree() {
        return this.incidenceAngleDegree;
    }

    public void setIncidenceAngleDegree(int incidenceAngleDegree) {
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }

    public void setShader(Shader shader) {
        if (shader != null) {
            this.shadeFractions = shader.getFractions();
            this.shadeColors = shader.getColors();
        }
    }

    @Override
    protected void paintDonut2DSliceEffect(Graphics2D g2d, Donut2D donut2D, Donut2DSlice slice) {
        double endY;
        double endX;
        Point2D.Double end;
        double startY;
        double deltaDegree = slice.getPercent() * 360.0;
        double centerX = donut2D.getCenterX();
        double centerY = donut2D.getCenterY();
        double medianDegree = slice.getStartAngleDegree() + deltaDegree / 2.0;
        if (medianDegree > 360.0) {
            medianDegree -= 360.0;
        }
        Point2D c = null;
        if (donut2D.getNature() == Donut2D.Donut2DNature.User) {
            c = donut2D.getHostPlugin().getProjection().userToPixel(new Point2D.Double(centerX, centerY));
        }
        if (donut2D.getNature() == Donut2D.Donut2DNature.Device) {
            c = new Point2D.Double(centerX, centerY);
        }
        centerX = c.getX() + slice.getDivergence() * Math.cos(Math.toRadians(medianDegree));
        centerY = c.getY() - slice.getDivergence() * Math.sin(Math.toRadians(medianDegree));
        double outerRadius = donut2D.getOuterRadius() - (double)this.offsetRadius;
        double innerRadius = donut2D.getInnerRadius() + (double)this.offsetRadius;
        Ellipse2D.Double outerEllipse = new Ellipse2D.Double(centerX - outerRadius, centerY - outerRadius, 2.0 * outerRadius, 2.0 * outerRadius);
        Ellipse2D.Double innerEllipse = new Ellipse2D.Double(centerX - innerRadius, centerY - innerRadius, 2.0 * innerRadius, 2.0 * innerRadius);
        double startX = centerX + outerRadius * Math.cos(Math.toRadians(this.incidenceAngleDegree));
        Point2D.Double start = new Point2D.Double(startX, startY = centerY - outerRadius * Math.sin(Math.toRadians(this.incidenceAngleDegree)));
        if (start.equals(end = new Point2D.Double(endX = centerX + outerRadius * Math.cos(Math.toRadians(this.incidenceAngleDegree + 180)), endY = centerY - outerRadius * Math.sin(Math.toRadians(this.incidenceAngleDegree + 180))))) {
            return;
        }
        if (this.startColor != null && this.endColor != null && this.shadeFractions == null) {
            this.colors = new Color[]{this.startColor, this.endColor};
            this.fractions = new float[]{0.0f, 1.0f};
        }
        if (this.shadeFractions != null && this.shadeColors != null) {
            this.colors = this.shadeColors;
            this.fractions = this.shadeFractions;
        }
        LinearGradientPaint shader = new LinearGradientPaint(start, end, this.fractions, this.colors);
        g2d.setPaint(shader);
        Area outerArea = new Area(outerEllipse);
        Area innerArea = new Area(innerEllipse);
        outerArea.subtract(innerArea);
        Area sliceArea = new Area(slice.getSlicePath());
        sliceArea.intersect(outerArea);
        g2d.fill(sliceArea);
    }
}

