/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.painter.fill;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.painter.fill.AbstractDonut2DSliceFill;

public class Donut2DSliceRadialFill
extends AbstractDonut2DSliceFill {
    private GradientFillType gradientFillType = GradientFillType.D_SC_D;

    public Donut2DSliceRadialFill() {
    }

    public GradientFillType getGradientBehavior() {
        return this.gradientFillType;
    }

    public void setGradientBehavior(GradientFillType gradientBehavior) {
        this.gradientFillType = gradientBehavior;
    }

    public Donut2DSliceRadialFill(GradientFillType gradientBehavior) {
        this.gradientFillType = gradientBehavior;
    }

    @Override
    protected final void paintDonut2DSliceFill(Graphics2D g2d, Donut2D pie, Donut2DSlice pieSection) {
        g2d.setColor(pieSection.getThemeColor());
        double centerX = pie.getCenterX();
        double centerY = pie.getCenterY();
        double deltaDegree = pieSection.getPercent() * 360.0;
        double medianDegree = pieSection.getStartAngleDegree() + deltaDegree / 2.0;
        if (medianDegree > 360.0) {
            medianDegree -= 360.0;
        }
        Point2D c = null;
        if (pie.getNature() == Donut2D.Donut2DNature.User) {
            c = pie.getHostPlugin().getProjection().userToPixel(new Point2D.Double(centerX, centerY));
        }
        if (pie.getNature() == Donut2D.Donut2DNature.Device) {
            c = new Point2D.Double(centerX, centerY);
        }
        centerX = c.getX() + pieSection.getDivergence() * Math.cos(Math.toRadians(medianDegree));
        centerY = c.getY() - pieSection.getDivergence() * Math.sin(Math.toRadians(medianDegree));
        Point2D.Double cent = new Point2D.Double(centerX, centerY);
        double or = pie.getOuterRadius();
        double ir = pie.getInnerRadius();
        double mr = ir + (or - ir) / 2.0;
        double orf = 1.0;
        double mrf = mr / or;
        double irf = ir / or;
        float[] dist = new float[]{0.0f, (float)irf, (float)mrf, (float)orf};
        RadialGradientPaint p = new RadialGradientPaint(cent, (float)or, dist, this.getColors(pieSection.getThemeColor()), MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2d.setPaint(p);
        g2d.fill(pieSection.getSlicePath());
    }

    private Color[] getColors(Color sliceColor) {
        if (this.gradientFillType == GradientFillType.B_D_B) {
            Color cStart = sliceColor.brighter();
            Color cMedian = sliceColor.darker();
            Color cEnd = sliceColor.brighter();
            Color[] cols = new Color[]{cStart, cStart, cMedian, cEnd};
            return cols;
        }
        if (this.gradientFillType == GradientFillType.B_SC_B) {
            Color cStart = sliceColor.brighter();
            Color cMedian = sliceColor;
            Color cEnd = sliceColor.brighter();
            Color[] cols = new Color[]{cStart, cStart, cMedian, cEnd};
            return cols;
        }
        if (this.gradientFillType == GradientFillType.D_SC_D) {
            Color cStart = sliceColor.darker();
            Color cMedian = sliceColor;
            Color cEnd = sliceColor.darker();
            Color[] cols = new Color[]{cStart, cStart, cMedian, cEnd};
            return cols;
        }
        if (this.gradientFillType == GradientFillType.D_B_D) {
            Color cStart = sliceColor.darker();
            Color cMedian = sliceColor.brighter();
            Color cEnd = sliceColor.darker();
            Color[] cols = new Color[]{cStart, cStart, cMedian, cEnd};
            return cols;
        }
        if (this.gradientFillType == GradientFillType.SC_B_SC) {
            Color cStart = sliceColor;
            Color cMedian = sliceColor.brighter();
            Color cEnd = sliceColor;
            Color[] cols = new Color[]{cStart, cStart, cMedian, cEnd};
            return cols;
        }
        if (this.gradientFillType == GradientFillType.SC_D_SC) {
            Color cStart = sliceColor;
            Color cMedian = sliceColor.darker();
            Color cEnd = sliceColor;
            Color[] cols = new Color[]{cStart, cStart, cMedian, cEnd};
            return cols;
        }
        Color cStart = sliceColor.darker();
        Color cMedian = sliceColor;
        Color cEnd = sliceColor.darker();
        Color[] cols = new Color[]{cStart, cStart, cMedian, cEnd};
        return cols;
    }

    public static enum GradientFillType {
        B_D_B("B_D_B"),
        B_SC_B("B_SC_B"),
        D_SC_D("D_SC_D"),
        D_B_D("D_B_D"),
        SC_B_SC("SC_B_SC"),
        SC_D_SC("SC_D_SC");

        private String donut2DFillType;

        private GradientFillType(String donut2DFillType) {
            this.donut2DFillType = donut2DFillType;
        }

        public String getDonut2DFillType() {
            return this.donut2DFillType;
        }

        public static GradientFillType parse(String fillType) {
            if (B_D_B.getDonut2DFillType().equalsIgnoreCase(fillType)) {
                return B_D_B;
            }
            if (B_SC_B.getDonut2DFillType().equalsIgnoreCase(fillType)) {
                return B_SC_B;
            }
            if (D_SC_D.getDonut2DFillType().equalsIgnoreCase(fillType)) {
                return D_SC_D;
            }
            if (D_B_D.getDonut2DFillType().equalsIgnoreCase(fillType)) {
                return D_B_D;
            }
            if (SC_B_SC.getDonut2DFillType().equalsIgnoreCase(fillType)) {
                return SC_B_SC;
            }
            if (SC_D_SC.getDonut2DFillType().equalsIgnoreCase(fillType)) {
                return SC_D_SC;
            }
            return SC_B_SC;
        }
    }
}

