/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut3d;

import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jensoft.core.plugin.donut3d.Donut3DPlugin;
import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.painter.paint.AbstractDonut3DPaint;

public class Donut3D {
    private double innerRadius;
    private double outerRadius;
    private double thickness;
    private double projectionThickness;
    private double tilt;
    private double outerA;
    private double outerB;
    private double innerA;
    private double innerB;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double startAngleDegree = 35.0;
    private AbstractDonut3DPaint donut3DPaint;
    private Donut3DNature donut3DNature = Donut3DNature.Donut3DUser;
    private Donut3DPlugin hostPlugin;
    private List<Donut3DSlice> slices = new ArrayList<Donut3DSlice>();
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Donut3DPlugin getHostPlugin() {
        return this.hostPlugin;
    }

    public void setHostPlugin(Donut3DPlugin hostPlugin) {
        this.hostPlugin = hostPlugin;
    }

    public double getProjectionThickness() {
        return this.projectionThickness;
    }

    public AbstractDonut3DPaint getDonut3DPaint() {
        return this.donut3DPaint;
    }

    public void setDonut3DPaint(AbstractDonut3DPaint donut3dPaint) {
        this.donut3DPaint = donut3dPaint;
    }

    public Donut3DNature getDonut3DNature() {
        return this.donut3DNature;
    }

    public void setDonut3DNature(Donut3DNature nature) {
        this.donut3DNature = nature;
    }

    public void addSlice(Donut3DSlice slice) {
        slice.setHost(this);
        this.slices.add(slice);
    }

    public List<Donut3DSlice> getSlices() {
        return this.slices;
    }

    public void removeAllSliceLabels() {
        for (Donut3DSlice slice : this.getSlices()) {
            slice.removeAllSliceLabels();
        }
    }

    private void normalizeSlice() {
        Donut3DSlice s;
        int i;
        double sum = 0.0;
        for (i = 0; i < this.slices.size(); ++i) {
            s = this.slices.get(i);
            sum += s.getValue();
        }
        for (i = 0; i < this.slices.size(); ++i) {
            s = this.slices.get(i);
            double percent = s.getValue() / sum;
            s.setNormalizedValue(percent);
        }
    }

    public void solveDonut3D() {
        this.solveRadius();
        this.solveThickness();
        this.normalizeSlice();
        double buildAngleDegree = this.startAngleDegree;
        for (Donut3DSlice slice : this.slices) {
            this.solveSliceGeometry(slice, buildAngleDegree);
            this.solveSliceFragments(slice, buildAngleDegree);
            buildAngleDegree = slice.getEndAngleDegree();
            if (!(buildAngleDegree > 360.0)) continue;
            buildAngleDegree -= 360.0;
        }
    }

    private Donut3DSlice createSliceFragment(Donut3DSlice donutSlice, double startAngleDegree, double extendsDegree) {
        Donut3DSlice fragment = new Donut3DSlice(donutSlice.getName() + ".part", donutSlice.getThemeColor());
        fragment.setFragment(true);
        fragment.setParentSlice(donutSlice);
        if (startAngleDegree >= 0.0 && startAngleDegree < 180.0) {
            fragment.setType(Donut3DSlice.Type.Back);
            fragment.setName(fragment.getName() + ".back");
        } else if (startAngleDegree >= 180.0 && startAngleDegree < 360.0) {
            fragment.setType(Donut3DSlice.Type.Front);
            fragment.setName(fragment.getName() + ".front");
        }
        Point2D c = null;
        if (this.getDonut3DNature() == Donut3DNature.Donut3DUser) {
            c = this.getHostPlugin().getProjection().userToPixel(new Point2D.Double(this.centerX, this.centerY));
        }
        if (this.getDonut3DNature() == Donut3DNature.Donut3DDevice) {
            c = new Point2D.Double(this.centerX, this.centerY);
        }
        double centX = c.getX();
        double centY = c.getY();
        double exploseTiltRadius = new Double(donutSlice.getDivergence()) / 90.0;
        double exploseRadius = exploseTiltRadius * this.tilt;
        double exploseA = donutSlice.getDivergence();
        double exploseB = exploseRadius;
        double cX = centX + exploseA * Math.cos(Math.toRadians(donutSlice.getStartAngleDegree() + donutSlice.getExtendsDegree() / 2.0));
        double cY = centY - exploseB * Math.sin(Math.toRadians(donutSlice.getStartAngleDegree() + donutSlice.getExtendsDegree() / 2.0));
        double cornerOuterXA = cX - this.getOuterA();
        double cornerOuterYBTop = cY - this.getOuterB();
        double cornerOuterYBBottom = cY - this.getOuterB() + this.projectionThickness;
        Arc2D.Double outerArcTop = new Arc2D.Double(cornerOuterXA, cornerOuterYBTop, 2.0 * this.getOuterA(), 2.0 * this.getOuterB(), startAngleDegree, extendsDegree, 0);
        Arc2D.Double outerArcBottom = new Arc2D.Double(cornerOuterXA, cornerOuterYBBottom, 2.0 * this.getOuterA(), 2.0 * this.getOuterB(), startAngleDegree, extendsDegree, 0);
        Arc2D.Double outerArcBottomRevert = new Arc2D.Double(cornerOuterXA, cornerOuterYBBottom, 2.0 * this.getOuterA(), 2.0 * this.getOuterB(), startAngleDegree + extendsDegree, -extendsDegree, 0);
        fragment.setOuterArcTop(outerArcTop);
        fragment.setOuterArcBottom(outerArcBottom);
        double cornerInnerXA = cX - this.getInnerA();
        double cornerInnerYBTop = cY - this.getInnerB();
        double cornerInnerYBBottom = cY + this.projectionThickness - this.getInnerB();
        Arc2D.Double innerArcTop = new Arc2D.Double(cornerInnerXA, cornerInnerYBTop, 2.0 * this.getInnerA(), 2.0 * this.getInnerB(), startAngleDegree + extendsDegree, -extendsDegree, 0);
        Arc2D.Double innerArcBottom = new Arc2D.Double(cornerInnerXA, cornerInnerYBBottom, 2.0 * this.getInnerA(), 2.0 * this.getInnerB(), startAngleDegree + extendsDegree, -extendsDegree, 0);
        Arc2D.Double innerArcBottomRevert = new Arc2D.Double(cornerInnerXA, cornerInnerYBBottom, 2.0 * this.getInnerA(), 2.0 * this.getInnerB(), startAngleDegree, extendsDegree, 0);
        fragment.setInnerArcTop(innerArcTop);
        fragment.setInnerArcBottom(innerArcBottom);
        GeneralPath topFace = new GeneralPath();
        topFace.append(outerArcTop, false);
        topFace.append(innerArcTop, true);
        topFace.closePath();
        fragment.setTopFace(topFace);
        GeneralPath bottomFace = new GeneralPath();
        bottomFace.append(outerArcBottom, false);
        bottomFace.append(innerArcBottom, true);
        bottomFace.closePath();
        fragment.setBottomFace(bottomFace);
        GeneralPath pfaceStart = new GeneralPath();
        pfaceStart.moveTo(outerArcTop.getStartPoint().getX(), outerArcTop.getStartPoint().getY());
        pfaceStart.lineTo(innerArcTop.getEndPoint().getX(), innerArcTop.getEndPoint().getY());
        pfaceStart.lineTo(innerArcBottom.getEndPoint().getX(), innerArcBottom.getEndPoint().getY());
        pfaceStart.lineTo(outerArcBottom.getStartPoint().getX(), outerArcBottom.getStartPoint().getY());
        pfaceStart.closePath();
        fragment.setStartFace(pfaceStart);
        Line2D.Double startExternalLine = new Line2D.Double(outerArcTop.getStartPoint().getX(), outerArcTop.getStartPoint().getY(), outerArcBottom.getStartPoint().getX(), outerArcBottom.getStartPoint().getY());
        Line2D.Double startInternalLine = new Line2D.Double(innerArcTop.getEndPoint().getX(), innerArcTop.getEndPoint().getY(), innerArcBottom.getEndPoint().getX(), innerArcBottom.getEndPoint().getY());
        Line2D.Double startBottomLine = new Line2D.Double(innerArcBottom.getEndPoint().getX(), innerArcBottom.getEndPoint().getY(), outerArcBottom.getStartPoint().getX(), outerArcBottom.getStartPoint().getY());
        Line2D.Double startTopLine = new Line2D.Double(innerArcTop.getEndPoint().getX(), innerArcTop.getEndPoint().getY(), outerArcTop.getStartPoint().getX(), outerArcTop.getStartPoint().getY());
        fragment.setStartOuterLine(startExternalLine);
        fragment.setStartInnerLine(startInternalLine);
        fragment.setStartTopLine(startTopLine);
        fragment.setStartBottomLine(startBottomLine);
        GeneralPath pfaceEnd = new GeneralPath();
        pfaceEnd.moveTo(outerArcTop.getEndPoint().getX(), outerArcTop.getEndPoint().getY());
        pfaceEnd.lineTo(innerArcTop.getStartPoint().getX(), innerArcTop.getStartPoint().getY());
        pfaceEnd.lineTo(innerArcBottom.getStartPoint().getX(), innerArcBottom.getStartPoint().getY());
        pfaceEnd.lineTo(outerArcBottom.getEndPoint().getX(), outerArcBottom.getEndPoint().getY());
        pfaceEnd.closePath();
        fragment.setEndFace(pfaceEnd);
        Line2D.Double endExternalLine = new Line2D.Double(outerArcTop.getEndPoint().getX(), outerArcTop.getEndPoint().getY(), outerArcBottom.getEndPoint().getX(), outerArcBottom.getEndPoint().getY());
        Line2D.Double endInternalLine = new Line2D.Double(innerArcTop.getStartPoint().getX(), innerArcTop.getStartPoint().getY(), innerArcBottom.getStartPoint().getX(), innerArcBottom.getStartPoint().getY());
        Line2D.Double endBottomLine = new Line2D.Double(innerArcBottom.getStartPoint().getX(), innerArcBottom.getStartPoint().getY(), outerArcBottom.getEndPoint().getX(), outerArcBottom.getEndPoint().getY());
        Line2D.Double endTopLine = new Line2D.Double(innerArcTop.getStartPoint().getX(), innerArcTop.getStartPoint().getY(), outerArcTop.getEndPoint().getX(), outerArcTop.getEndPoint().getY());
        fragment.setEndOuterLine(endExternalLine);
        fragment.setEndInnerLine(endInternalLine);
        fragment.setEndTopLine(endTopLine);
        fragment.setEndBottomLine(endBottomLine);
        GeneralPath internalFace = new GeneralPath();
        internalFace.append(innerArcTop, false);
        internalFace.append(innerArcBottomRevert, true);
        internalFace.closePath();
        fragment.setInnerFace(internalFace);
        GeneralPath externalFace = new GeneralPath();
        externalFace.append(outerArcTop, false);
        externalFace.append(outerArcBottomRevert, true);
        externalFace.closePath();
        fragment.setOuterFace(externalFace);
        fragment.setStartAngleDegree(startAngleDegree);
        fragment.setEndAngleDegree(startAngleDegree + extendsDegree);
        Ellipse2D.Double innerEllipse = new Ellipse2D.Double(cX - this.innerA, cY - this.innerB, 2.0 * this.innerA, 2.0 * this.innerB);
        fragment.setInnerModel(innerEllipse);
        return fragment;
    }

    public Area getTopFace() {
        Area top = new Area();
        for (Donut3DSlice s : this.slices) {
            List<Donut3DSlice> fragments = s.getFragments();
            for (Donut3DSlice fragment : fragments) {
                top.add(new Area(fragment.getTopFace()));
            }
        }
        return top;
    }

    public Area getInnerBackFace() {
        Area innerbackface = new Area();
        for (Donut3DSlice s : this.slices) {
            List<Donut3DSlice> fragments = s.getFragments();
            for (Donut3DSlice fragment : fragments) {
                if (fragment.getType() != Donut3DSlice.Type.Back) continue;
                innerbackface.add(new Area(fragment.getInnerFace()));
            }
        }
        return innerbackface;
    }

    public Area getEndFace() {
        Area endface = new Area();
        for (Donut3DSlice s : this.slices) {
            List<Donut3DSlice> fragments = s.getFragments();
            for (Donut3DSlice fragment : fragments) {
                if (!s.isLast(fragment)) continue;
                endface.add(new Area(fragment.getEndFace()));
            }
        }
        return endface;
    }

    public Area getStartFace() {
        Area endface = new Area();
        for (Donut3DSlice s : this.slices) {
            List<Donut3DSlice> fragments = s.getFragments();
            for (Donut3DSlice fragment : fragments) {
                if (!s.isFirst(fragment)) continue;
                endface.add(new Area(fragment.getStartFace()));
            }
        }
        return endface;
    }

    public Donut3DSlice getSliceOnAngle(double angleDegree) {
        if (angleDegree < 0.0 && angleDegree > 360.0) {
            throw new IllegalArgumentException("angleDegree out of range [0,360]");
        }
        for (Donut3DSlice s : this.slices) {
            boolean f2;
            if (s.getEndAngleDegree() <= 360.0) {
                if (!(s.getStartAngleDegree() <= angleDegree) || !(s.getEndAngleDegree() >= angleDegree)) continue;
                return s;
            }
            if (!(s.getEndAngleDegree() > 360.0)) continue;
            double reboundAngleDegree = angleDegree;
            if (angleDegree < s.getStartAngleDegree()) {
                reboundAngleDegree = angleDegree + 360.0;
            }
            boolean f1 = s.getStartAngleDegree() <= reboundAngleDegree;
            boolean bl = f2 = s.getEndAngleDegree() >= reboundAngleDegree;
            if (!f1 || !f2) continue;
            return s;
        }
        return null;
    }

    public List<Donut3DSlice> getSlicesOnAngle(double angleDegree) {
        if (angleDegree < 0.0 && angleDegree > 360.0) {
            throw new IllegalArgumentException("angleDegree out of range [0,360]");
        }
        ArrayList<Donut3DSlice> slicesOnAngle = new ArrayList<Donut3DSlice>();
        for (Donut3DSlice s : this.getSlices()) {
            boolean f2;
            if (s.getEndAngleDegree() <= 360.0) {
                if (!(s.getStartAngleDegree() <= angleDegree) || !(s.getEndAngleDegree() >= angleDegree)) continue;
                slicesOnAngle.add(s);
                continue;
            }
            if (!(s.getEndAngleDegree() > 360.0)) continue;
            double reboundAngleDegree = angleDegree;
            if (angleDegree < s.getStartAngleDegree()) {
                reboundAngleDegree = angleDegree + 360.0;
            }
            boolean f1 = s.getStartAngleDegree() <= reboundAngleDegree;
            boolean bl = f2 = s.getEndAngleDegree() >= reboundAngleDegree;
            if (!f1 || !f2) continue;
            slicesOnAngle.add(s);
        }
        return slicesOnAngle;
    }

    public List<Donut3DSlice> getSlicesOnAngle(double startAngleDegree, double endAngleDegree) {
        if (startAngleDegree < 0.0 || startAngleDegree > 360.0 || endAngleDegree < 0.0 || endAngleDegree > 360.0) {
            throw new IllegalArgumentException("StarAngleDegree and EndAngleDegree out of range [0,360]");
        }
        if (endAngleDegree < startAngleDegree) {
            throw new IllegalArgumentException("EndAngleDegree should be  greater than StartAngleDegree");
        }
        ArrayList<Donut3DSlice> slicesOnAngle = new ArrayList<Donut3DSlice>();
        for (Donut3DSlice s : this.getSlices()) {
            if (s.getStartAngleDegree() >= startAngleDegree && s.getEndAngleDegree() >= startAngleDegree && s.getStartAngleDegree() <= endAngleDegree && s.getEndAngleDegree() <= endAngleDegree) {
                slicesOnAngle.add(s);
                continue;
            }
            if (s.getStartAngleDegree() <= startAngleDegree && s.getEndAngleDegree() >= startAngleDegree && s.getStartAngleDegree() <= endAngleDegree && s.getEndAngleDegree() <= endAngleDegree) {
                slicesOnAngle.add(s);
                continue;
            }
            if (s.getStartAngleDegree() >= startAngleDegree && s.getEndAngleDegree() >= startAngleDegree && s.getStartAngleDegree() <= endAngleDegree && s.getEndAngleDegree() >= endAngleDegree) {
                slicesOnAngle.add(s);
                continue;
            }
            if (!(s.getStartAngleDegree() <= startAngleDegree) || !(s.getEndAngleDegree() >= startAngleDegree) || !(s.getStartAngleDegree() <= endAngleDegree) || !(s.getEndAngleDegree() >= endAngleDegree)) continue;
            slicesOnAngle.add(s);
        }
        return slicesOnAngle;
    }

    public List<Donut3DSlice> getSlicesFragmentOnAngle(Donut3DSlice sliceParent, double startAngleDegree, double endAngleDegree) {
        if (startAngleDegree < 0.0 || startAngleDegree > 360.0 || endAngleDegree < 0.0 || endAngleDegree > 360.0) {
            throw new IllegalArgumentException("StarAngleDegree and EndAngleDegree out of range [0,360]");
        }
        if (endAngleDegree < startAngleDegree) {
            throw new IllegalArgumentException("EndAngleDegree should be  greater than StartAngleDegree");
        }
        ArrayList<Donut3DSlice> slicesOnAngle = new ArrayList<Donut3DSlice>();
        for (Donut3DSlice s : sliceParent.getFragments()) {
            if (s.getStartAngleDegree() >= startAngleDegree && s.getEndAngleDegree() >= startAngleDegree && s.getStartAngleDegree() <= endAngleDegree && s.getEndAngleDegree() <= endAngleDegree) {
                slicesOnAngle.add(s);
                continue;
            }
            if (s.getStartAngleDegree() <= startAngleDegree && s.getEndAngleDegree() >= startAngleDegree && s.getStartAngleDegree() <= endAngleDegree && s.getEndAngleDegree() <= endAngleDegree) {
                slicesOnAngle.add(s);
                continue;
            }
            if (s.getStartAngleDegree() >= startAngleDegree && s.getEndAngleDegree() >= startAngleDegree && s.getStartAngleDegree() <= endAngleDegree && s.getEndAngleDegree() >= endAngleDegree) {
                slicesOnAngle.add(s);
                continue;
            }
            if (!(s.getStartAngleDegree() <= startAngleDegree) || !(s.getEndAngleDegree() >= startAngleDegree) || !(s.getStartAngleDegree() <= endAngleDegree) || !(s.getEndAngleDegree() >= endAngleDegree)) continue;
            slicesOnAngle.add(s);
        }
        return slicesOnAngle;
    }

    public void clearPaintFlag() {
        for (Donut3DSlice slices : this.getSlices()) {
            slices.setPainted(false);
        }
    }

    private void solveSliceFragments(Donut3DSlice donutSlice, double buildAngleDegree) {
        donutSlice.clearFragment();
        donutSlice.setPainted(false);
        double sliceStartDegree = buildAngleDegree;
        double sliceExtendsDegree = donutSlice.getNormalizedValue() * 360.0;
        donutSlice.setStartAngleDegree(sliceStartDegree);
        donutSlice.setEndAngleDegree(sliceStartDegree + sliceExtendsDegree);
        double fragmentStartAngleDegree = sliceStartDegree;
        double fragmentExtends = sliceExtendsDegree;
        double resteExtends = sliceExtendsDegree;
        int count = 0;
        while (resteExtends > 0.0 && count++ < 4) {
            fragmentExtends = this.getFragmentExtendsDegree(sliceStartDegree, sliceExtendsDegree, fragmentStartAngleDegree, resteExtends);
            Donut3DSlice fragment = this.createSliceFragment(donutSlice, fragmentStartAngleDegree, fragmentExtends);
            donutSlice.addFragment(fragment);
            resteExtends -= fragmentExtends;
            if (!((fragmentStartAngleDegree += fragmentExtends) >= 360.0)) continue;
            fragmentStartAngleDegree -= 360.0;
        }
    }

    private double getFragmentExtendsDegree(double sliceStartDegree, double sliceExtendsDegree, double fragmentStartDegree, double resteExtendsDegree) {
        if (fragmentStartDegree >= 0.0 && fragmentStartDegree < 180.0) {
            double potentialExtends = 180.0 - fragmentStartDegree;
            if (potentialExtends <= resteExtendsDegree) {
                return potentialExtends;
            }
            return resteExtendsDegree;
        }
        if (fragmentStartDegree >= 180.0 && fragmentStartDegree < 360.0) {
            double potentialExtends = 360.0 - fragmentStartDegree;
            if (potentialExtends <= resteExtendsDegree) {
                return potentialExtends;
            }
            return resteExtendsDegree;
        }
        return 0.0;
    }

    private void solveSliceGeometry(Donut3DSlice donutSlice, double buildAngleDegree) {
        double deltaDegree = donutSlice.getNormalizedValue() * 360.0;
        Point2D c = null;
        if (this.getDonut3DNature() == Donut3DNature.Donut3DUser) {
            c = this.getHostPlugin().getProjection().userToPixel(new Point2D.Double(this.centerX, this.centerY));
        }
        if (this.getDonut3DNature() == Donut3DNature.Donut3DDevice) {
            c = new Point2D.Double(this.centerX, this.centerY);
        }
        double centX = c.getX();
        double centY = c.getY();
        double exploseTiltRadius = new Double(donutSlice.getDivergence()) / 90.0;
        double exploseRadius = exploseTiltRadius * this.tilt;
        double exploseA = donutSlice.getDivergence();
        double exploseB = exploseRadius;
        double cX = centX + exploseA * Math.cos(Math.toRadians(buildAngleDegree + deltaDegree / 2.0));
        double cY = centY - exploseB * Math.sin(Math.toRadians(buildAngleDegree + deltaDegree / 2.0));
        donutSlice.setCenterX(cX);
        donutSlice.setCenterY(cY);
        double cornerOuterXA = cX - this.getOuterA();
        double cornerOuterYBTop = cY - this.getOuterB();
        double cornerOuterYBBottom = cY - this.getOuterB() + this.projectionThickness;
        Arc2D.Double outerArcTop = new Arc2D.Double(cornerOuterXA, cornerOuterYBTop, 2.0 * this.getOuterA(), 2.0 * this.getOuterB(), buildAngleDegree, deltaDegree, 0);
        Arc2D.Double outerArcBottom = new Arc2D.Double(cornerOuterXA, cornerOuterYBBottom, 2.0 * this.getOuterA(), 2.0 * this.getOuterB(), buildAngleDegree, deltaDegree, 0);
        Arc2D.Double outerArcBottomRevert = new Arc2D.Double(cornerOuterXA, cornerOuterYBBottom, 2.0 * this.getOuterA(), 2.0 * this.getOuterB(), buildAngleDegree + deltaDegree, -deltaDegree, 0);
        donutSlice.setOuterArcTop(outerArcTop);
        donutSlice.setOuterArcBottom(outerArcBottom);
        double cornerInnerXA = cX - this.getInnerA();
        double cornerInnerYBTop = cY - this.getInnerB();
        double cornerInnerYBBottom = cY + this.projectionThickness - this.getInnerB();
        Arc2D.Double innerArcTop = new Arc2D.Double(cornerInnerXA, cornerInnerYBTop, 2.0 * this.getInnerA(), 2.0 * this.getInnerB(), buildAngleDegree + deltaDegree, -deltaDegree, 0);
        Arc2D.Double innerArcBottom = new Arc2D.Double(cornerInnerXA, cornerInnerYBBottom, 2.0 * this.getInnerA(), 2.0 * this.getInnerB(), buildAngleDegree + deltaDegree, -deltaDegree, 0);
        Arc2D.Double innerArcBottomRevert = new Arc2D.Double(cornerInnerXA, cornerInnerYBBottom, 2.0 * this.getInnerA(), 2.0 * this.getInnerB(), buildAngleDegree, deltaDegree, 0);
        donutSlice.setInnerArcTop(innerArcTop);
        donutSlice.setInnerArcBottom(innerArcBottom);
        GeneralPath topFace = new GeneralPath();
        topFace.append(outerArcTop, false);
        topFace.append(innerArcTop, true);
        topFace.closePath();
        donutSlice.setTopFace(topFace);
        GeneralPath bottomFace = new GeneralPath();
        bottomFace.append(outerArcBottom, false);
        bottomFace.append(innerArcBottom, true);
        bottomFace.closePath();
        donutSlice.setBottomFace(bottomFace);
        GeneralPath pfaceStart = new GeneralPath();
        pfaceStart.moveTo(outerArcTop.getStartPoint().getX(), outerArcTop.getStartPoint().getY());
        pfaceStart.lineTo(innerArcTop.getEndPoint().getX(), innerArcTop.getEndPoint().getY());
        pfaceStart.lineTo(innerArcBottom.getEndPoint().getX(), innerArcBottom.getEndPoint().getY());
        pfaceStart.lineTo(outerArcBottom.getStartPoint().getX(), outerArcBottom.getStartPoint().getY());
        pfaceStart.closePath();
        donutSlice.setStartFace(pfaceStart);
        Line2D.Double startExternalLine = new Line2D.Double(outerArcTop.getStartPoint().getX(), outerArcTop.getStartPoint().getY(), outerArcBottom.getStartPoint().getX(), outerArcBottom.getStartPoint().getY());
        Line2D.Double startInternalLine = new Line2D.Double(innerArcTop.getEndPoint().getX(), innerArcTop.getEndPoint().getY(), innerArcBottom.getEndPoint().getX(), innerArcBottom.getEndPoint().getY());
        Line2D.Double startBottomLine = new Line2D.Double(innerArcBottom.getEndPoint().getX(), innerArcBottom.getEndPoint().getY(), outerArcBottom.getStartPoint().getX(), outerArcBottom.getStartPoint().getY());
        Line2D.Double startTopLine = new Line2D.Double(innerArcTop.getEndPoint().getX(), innerArcTop.getEndPoint().getY(), outerArcTop.getStartPoint().getX(), outerArcTop.getStartPoint().getY());
        donutSlice.setStartOuterLine(startExternalLine);
        donutSlice.setStartInnerLine(startInternalLine);
        donutSlice.setStartTopLine(startTopLine);
        donutSlice.setStartBottomLine(startBottomLine);
        GeneralPath pfaceEnd = new GeneralPath();
        pfaceEnd.moveTo(outerArcTop.getEndPoint().getX(), outerArcTop.getEndPoint().getY());
        pfaceEnd.lineTo(innerArcTop.getStartPoint().getX(), innerArcTop.getStartPoint().getY());
        pfaceEnd.lineTo(innerArcBottom.getStartPoint().getX(), innerArcBottom.getStartPoint().getY());
        pfaceEnd.lineTo(outerArcBottom.getEndPoint().getX(), outerArcBottom.getEndPoint().getY());
        pfaceEnd.closePath();
        donutSlice.setEndFace(pfaceEnd);
        Line2D.Double endExternalLine = new Line2D.Double(outerArcTop.getEndPoint().getX(), outerArcTop.getEndPoint().getY(), outerArcBottom.getEndPoint().getX(), outerArcBottom.getEndPoint().getY());
        Line2D.Double endInternalLine = new Line2D.Double(innerArcTop.getStartPoint().getX(), innerArcTop.getStartPoint().getY(), innerArcBottom.getStartPoint().getX(), innerArcBottom.getStartPoint().getY());
        Line2D.Double endBottomLine = new Line2D.Double(innerArcBottom.getStartPoint().getX(), innerArcBottom.getStartPoint().getY(), outerArcBottom.getEndPoint().getX(), outerArcBottom.getEndPoint().getY());
        Line2D.Double endTopLine = new Line2D.Double(innerArcTop.getStartPoint().getX(), innerArcTop.getStartPoint().getY(), outerArcTop.getEndPoint().getX(), outerArcTop.getEndPoint().getY());
        donutSlice.setEndOuterLine(endExternalLine);
        donutSlice.setEndInnerLine(endInternalLine);
        donutSlice.setEndTopLine(endTopLine);
        donutSlice.setEndBottomLine(endBottomLine);
        GeneralPath internalFace = new GeneralPath();
        internalFace.append(innerArcTop, false);
        internalFace.append(innerArcBottomRevert, true);
        internalFace.closePath();
        donutSlice.setInnerFace(internalFace);
        GeneralPath externalFace = new GeneralPath();
        externalFace.append(outerArcTop, false);
        externalFace.append(outerArcBottomRevert, true);
        externalFace.closePath();
        donutSlice.setOuterFace(externalFace);
        donutSlice.setStartAngleDegree(buildAngleDegree);
        donutSlice.setEndAngleDegree(buildAngleDegree + deltaDegree);
    }

    public double getOuterA() {
        return this.outerA;
    }

    public double getOuterB() {
        return this.outerB;
    }

    public double getInnerA() {
        return this.innerA;
    }

    public double getInnerB() {
        return this.innerB;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double centerY) {
        this.centerY = centerY;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        if (startAngleDegree >= 360.0) {
            throw new IllegalArgumentException("start angle degree out of range [0,360[");
        }
        this.startAngleDegree = startAngleDegree;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double innerRadius) {
        this.innerRadius = innerRadius;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double outerRadius) {
        this.outerRadius = outerRadius;
    }

    public double getTilt() {
        return this.tilt;
    }

    public void setTilt(double tilt) {
        if (tilt < 0.0 || tilt > 90.0) {
            throw new IllegalArgumentException("tilt out of range [0,90]");
        }
        this.tilt = tilt;
    }

    private void solveThickness() {
        double oneDegreeTiltThickness = this.thickness / 90.0;
        this.projectionThickness = oneDegreeTiltThickness * (90.0 - this.tilt);
    }

    private void solveRadius() {
        double oneTiltExternalProfil = new Double(this.outerRadius) / 90.0;
        double oneTiltInternalProfil = new Double(this.innerRadius) / 90.0;
        this.outerA = this.outerRadius;
        this.outerB = oneTiltExternalProfil * this.tilt;
        this.innerA = this.innerRadius;
        this.innerB = oneTiltInternalProfil * this.tilt;
    }

    public boolean isSliceLockEnter() {
        for (Donut3DSlice slice : this.getSlices()) {
            if (!slice.isLockEnter()) continue;
            return true;
        }
        return false;
    }

    public static boolean in(Donut3DSlice donutSlice, List<Donut3DSlice> slices) {
        for (Donut3DSlice donut3dSlice : slices) {
            if (!donut3dSlice.equals(donutSlice)) continue;
            return true;
        }
        return false;
    }

    public List<Donut3DSlice> getPaintOrderFragments() {
        ArrayList<Donut3DSlice> paintOrderFragments = new ArrayList<Donut3DSlice>();
        List<Donut3DSlice> firstSlices = this.getSlicesOnAngle(90.0);
        ArrayList<Donut3DSlice> flattenFirstSlicesFragments = new ArrayList<Donut3DSlice>();
        for (Donut3DSlice firstSlice : firstSlices) {
            flattenFirstSlicesFragments.addAll(firstSlice.getFragments());
        }
        List<Donut3DSlice> lastSlices = this.getSlicesOnAngle(270.0);
        ArrayList<Donut3DSlice> flattenLastSlicesFragments = new ArrayList<Donut3DSlice>();
        for (Donut3DSlice lastSlice : lastSlices) {
            flattenLastSlicesFragments.addAll(lastSlice.getFragments());
        }
        for (Donut3DSlice firstSliceFragment : flattenFirstSlicesFragments) {
            if (!(firstSliceFragment.getStartAngleDegree() <= 90.0) || !(firstSliceFragment.getEndAngleDegree() >= 90.0) || firstSliceFragment.getType() != Donut3DSlice.Type.Back) continue;
            paintOrderFragments.add(firstSliceFragment);
        }
        for (Donut3DSlice firstSliceFragment : flattenFirstSlicesFragments) {
            if (Donut3D.in(firstSliceFragment, paintOrderFragments) || Donut3D.in(firstSliceFragment, flattenLastSlicesFragments) || firstSliceFragment.getType() != Donut3DSlice.Type.Back) continue;
            paintOrderFragments.add(firstSliceFragment);
        }
        for (Donut3DSlice firstSliceFragment : flattenFirstSlicesFragments) {
            if (!(firstSliceFragment.getStartAngleDegree() <= 90.0) || !(firstSliceFragment.getEndAngleDegree() >= 90.0) || firstSliceFragment.getType() != Donut3DSlice.Type.Front) continue;
            paintOrderFragments.add(firstSliceFragment);
        }
        for (Donut3DSlice firstSliceFragment : flattenFirstSlicesFragments) {
            if (Donut3D.in(firstSliceFragment, paintOrderFragments) || Donut3D.in(firstSliceFragment, flattenLastSlicesFragments) || firstSliceFragment.getType() != Donut3DSlice.Type.Front) continue;
            paintOrderFragments.add(firstSliceFragment);
        }
        List<Donut3DSlice> slicesLeft = this.getSlicesOnAngle(90.0, 270.0);
        for (Donut3DSlice sliceLeft : slicesLeft) {
            List<Donut3DSlice> sliceLeftFragments = sliceLeft.getFragments();
            for (Donut3DSlice leftFragment : sliceLeftFragments) {
                if (Donut3D.in(leftFragment, paintOrderFragments) || Donut3D.in(leftFragment, flattenLastSlicesFragments)) continue;
                paintOrderFragments.add(leftFragment);
            }
        }
        Donut3DSlice zeroSlice = this.getSliceOnAngle(0.0);
        List<Donut3DSlice> slicesRight1 = this.getSlicesOnAngle(0.0, 90.0);
        Collections.reverse(slicesRight1);
        for (Donut3DSlice sliceRight1 : slicesRight1) {
            List<Donut3DSlice> right1Fragments = this.getSlicesFragmentOnAngle(sliceRight1, 0.0, 90.0);
            for (Donut3DSlice right1Fragment : right1Fragments) {
                if (Donut3D.in(right1Fragment, paintOrderFragments) || zeroSlice.getFragments().contains(right1Fragment)) continue;
                if (Donut3D.in(right1Fragment, flattenLastSlicesFragments)) {
                    for (Donut3DSlice dLastFragment : flattenLastSlicesFragments) {
                        if (!dLastFragment.equals(right1Fragment) || right1Fragment.getType() != Donut3DSlice.Type.Back) continue;
                        paintOrderFragments.add(right1Fragment);
                    }
                    continue;
                }
                paintOrderFragments.add(right1Fragment);
            }
        }
        List<Donut3DSlice> zeroFragments = zeroSlice.getFragments();
        for (int i = zeroFragments.size() - 1; i >= 0; --i) {
            Donut3DSlice zeroFragment = zeroFragments.get(i);
            if (zeroFragment == null || Donut3D.in(zeroFragment, paintOrderFragments)) continue;
            if (Donut3D.in(zeroFragment, flattenLastSlicesFragments)) {
                for (Donut3DSlice dLastFragment : flattenLastSlicesFragments) {
                    if (!dLastFragment.equals(zeroFragment) || zeroFragment.getType() != Donut3DSlice.Type.Back) continue;
                    paintOrderFragments.add(zeroFragment);
                }
                continue;
            }
            paintOrderFragments.add(zeroFragment);
        }
        List<Donut3DSlice> slicesRight2 = this.getSlicesOnAngle(270.0, 360.0);
        Collections.reverse(slicesRight2);
        for (Donut3DSlice sliceRight2 : slicesRight2) {
            List<Donut3DSlice> right2Fragments = this.getSlicesFragmentOnAngle(sliceRight2, 270.0, 360.0);
            for (Donut3DSlice right2Fragment : right2Fragments) {
                if (Donut3D.in(right2Fragment, paintOrderFragments) || zeroSlice.getFragments().contains(right2Fragment)) continue;
                if (Donut3D.in(right2Fragment, flattenLastSlicesFragments)) {
                    for (Donut3DSlice dLastFragment : flattenLastSlicesFragments) {
                        if (!dLastFragment.equals(right2Fragment) || right2Fragment.getType() != Donut3DSlice.Type.Back) continue;
                        paintOrderFragments.add(right2Fragment);
                    }
                    continue;
                }
                paintOrderFragments.add(right2Fragment);
            }
        }
        for (Donut3DSlice lastFragment : flattenLastSlicesFragments) {
            if (Donut3D.in(lastFragment, paintOrderFragments)) continue;
            paintOrderFragments.add(lastFragment);
        }
        return paintOrderFragments;
    }

    public List<Donut3DSlice> getPaintOrder() {
        this.getPaintOrderFragments();
        ArrayList<Donut3DSlice> paintOrder = new ArrayList<Donut3DSlice>();
        List<Donut3DSlice> firstSlices = this.getSlicesOnAngle(90.0);
        List<Donut3DSlice> lastSlices = this.getSlicesOnAngle(270.0);
        for (Donut3DSlice firstSlice : firstSlices) {
            if (firstSlice == null || Donut3D.in(firstSlice, paintOrder) || Donut3D.in(firstSlice, lastSlices)) continue;
            paintOrder.add(firstSlice);
        }
        List<Donut3DSlice> slicesLeft = this.getSlicesOnAngle(90.0, 270.0);
        for (Donut3DSlice sliceLeft : slicesLeft) {
            if (Donut3D.in(sliceLeft, paintOrder) || Donut3D.in(sliceLeft, lastSlices)) continue;
            paintOrder.add(sliceLeft);
        }
        Donut3DSlice zeroSlice = this.getSliceOnAngle(0.0);
        List<Donut3DSlice> slicesRight1 = this.getSlicesOnAngle(0.0, 90.0);
        Collections.reverse(slicesRight1);
        for (Donut3DSlice sliceRight1 : slicesRight1) {
            if (Donut3D.in(sliceRight1, paintOrder) || sliceRight1.equals(zeroSlice) || Donut3D.in(sliceRight1, lastSlices)) continue;
            paintOrder.add(sliceRight1);
        }
        if (zeroSlice != null && !Donut3D.in(zeroSlice, paintOrder) && !Donut3D.in(zeroSlice, lastSlices)) {
            paintOrder.add(zeroSlice);
        }
        List<Donut3DSlice> slicesRight2 = this.getSlicesOnAngle(270.0, 360.0);
        Collections.reverse(slicesRight2);
        for (Donut3DSlice sliceRight2 : slicesRight2) {
            if (Donut3D.in(sliceRight2, paintOrder) || Donut3D.in(sliceRight2, lastSlices)) continue;
            paintOrder.add(sliceRight2);
        }
        for (Donut3DSlice lastSlice : lastSlices) {
            if (lastSlice == null) continue;
            paintOrder.add(lastSlice);
        }
        return paintOrder;
    }

    public static enum Donut3DNature {
        Donut3DUser("user"),
        Donut3DDevice("device");

        private String nature;

        private Donut3DNature(String nature) {
            this.nature = nature;
        }

        public String getNature() {
            return this.nature;
        }

        public static Donut3DNature parseNature(String nature) {
            if (Donut3DDevice.getNature().equals(nature)) {
                return Donut3DDevice;
            }
            if (Donut3DUser.getNature().equals(nature)) {
                return Donut3DUser;
            }
            return Donut3DDevice;
        }
    }
}

