/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut3d;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Dithering;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.donut3d.Donut3D;
import org.jensoft.core.plugin.donut3d.Donut3DEvent;
import org.jensoft.core.plugin.donut3d.Donut3DListener;
import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.animator.AbstractDonut3DAnimator;
import org.jensoft.core.plugin.donut3d.painter.label.AbstractDonut3DSliceLabel;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class Donut3DPlugin
extends AbstractPlugin
implements AbstractPlugin.OnClickListener,
AbstractPlugin.OnEnterListener,
AbstractPlugin.OnExitListener,
AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener,
AbstractPlugin.OnMoveListener,
AbstractPlugin.OnDragListener {
    private List<Donut3D> donuts3D = new ArrayList<Donut3D>();
    private EventListenerList donut3DListenerList;

    public List<Donut3D> getDonuts3D() {
        return this.donuts3D;
    }

    public Donut3DPlugin() {
        this.setAntialiasing(Antialiasing.On);
        this.setTextAntialising(TextAntialiasing.On);
        this.setDithering(Dithering.On);
        this.donut3DListenerList = new EventListenerList();
        this.setOnMoveListener(this);
        this.setOnClickListener(this);
        this.setOnReleaseListener(this);
        this.setOnPressListener(this);
        this.setOnDragListener(this);
    }

    public void addDonut3DListener(Donut3DListener listener) {
        this.donut3DListenerList.add(Donut3DListener.class, listener);
    }

    public void removeDonut3DListener(Donut3DListener listener) {
        this.donut3DListenerList.remove(Donut3DListener.class, listener);
    }

    public void addDonut(Donut3D donut3D) {
        this.donuts3D.add(donut3D);
    }

    public void addDonutAnimator(AbstractDonut3DAnimator animator) {
        this.addDonut3DListener(animator);
    }

    private void solveDonut3D() {
        for (Donut3D donut3D : this.donuts3D) {
            donut3D.setHostPlugin(this);
            donut3D.solveDonut3D();
        }
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        this.solveDonut3D();
        for (Donut3D donut3D : this.donuts3D) {
            if (donut3D.getDonut3DPaint() != null) {
                donut3D.getDonut3DPaint().paintDonut3D(g2d, donut3D);
            }
            List<Donut3DSlice> slices = donut3D.getSlices();
            for (Donut3DSlice donut3DSlice : slices) {
                for (AbstractDonut3DSliceLabel label : donut3DSlice.getSliceLabels()) {
                    label.paintDonut3DSlice(g2d, donut3D, donut3DSlice);
                }
            }
        }
    }

    @Override
    public void onRelease(MouseEvent me) {
        for (Donut3D donut3d : this.donuts3D) {
            for (Donut3DSlice slice : donut3d.getSlices()) {
                if (slice.getSensibleArea() == null || !slice.getSensibleArea().contains(me.getX(), me.getY()) || !slice.isLockEnter()) continue;
                this.fireDonut3DReleased(slice);
            }
        }
    }

    @Override
    public void onPress(MouseEvent me) {
        for (Donut3D donut3d : this.donuts3D) {
            List<Donut3DSlice> slices = donut3d.getPaintOrder();
            Collections.reverse(slices);
            for (Donut3DSlice slice : slices) {
                if (slice.getSensibleArea() == null || !slice.getSensibleArea().contains(me.getX(), me.getY()) || !slice.isLockEnter()) continue;
                this.fireDonut3DPressed(slice);
                return;
            }
        }
    }

    @Override
    public void onExit(MouseEvent me) {
    }

    @Override
    public void onEnter(MouseEvent me) {
    }

    @Override
    public void onClick(MouseEvent me) {
        for (Donut3D donut3d : this.donuts3D) {
            List<Donut3DSlice> slices = donut3d.getPaintOrder();
            Collections.reverse(slices);
            for (Donut3DSlice slice : slices) {
                if (slice.getSensibleArea() == null || !slice.getSensibleArea().contains(me.getX(), me.getY()) || !slice.isLockEnter()) continue;
                this.fireDonut3DClicked(slice);
            }
        }
    }

    @Override
    public void onMove(MouseEvent me) {
        for (Donut3D donut3d : this.donuts3D) {
            for (Donut3DSlice slice : donut3d.getSlices()) {
                this.donut3DEnterExitTracker(slice, me.getX(), me.getY());
            }
        }
    }

    @Override
    public void onDrag(MouseEvent me) {
        for (Donut3D donut3d : this.donuts3D) {
            for (Donut3DSlice slice : donut3d.getSlices()) {
                this.donut3DEnterExitTracker(slice, me.getX(), me.getY());
            }
        }
    }

    private void donut3DEnterExitTracker(Donut3DSlice slice, int x, int y) {
        if (slice == null || slice.getSensibleArea() == null) {
            return;
        }
        if (slice.getSensibleArea().contains(x, y) && !slice.isLockEnter()) {
            slice.lockEnter();
            this.fireDonut3DEntered(slice);
        } else if (!slice.getSensibleArea().contains(x, y) && slice.isLockEnter()) {
            slice.unlockEnter();
            this.fireDonut3DExited(slice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDonut3DEntered(Donut3DSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = this.donut3DListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != Donut3DListener.class) continue;
                ((Donut3DListener)listeners[i + 1]).donut3DSliceEntered(new Donut3DEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDonut3DExited(Donut3DSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = this.donut3DListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != Donut3DListener.class) continue;
                ((Donut3DListener)listeners[i + 1]).donut3DSliceExited(new Donut3DEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDonut3DClicked(Donut3DSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = this.donut3DListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != Donut3DListener.class) continue;
                ((Donut3DListener)listeners[i + 1]).donut3DSliceClicked(new Donut3DEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDonut3DPressed(Donut3DSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = this.donut3DListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != Donut3DListener.class) continue;
                ((Donut3DListener)listeners[i + 1]).donut3DSlicePressed(new Donut3DEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDonut3DReleased(Donut3DSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = this.donut3DListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != Donut3DListener.class) continue;
                ((Donut3DListener)listeners[i + 1]).donut3DSliceReleased(new Donut3DEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

