/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut3d;

import java.awt.Color;
import java.awt.Font;
import org.jensoft.core.catalog.nature.JenSoftView;
import org.jensoft.core.catalog.ui.ViewFrameUI;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.palette.color.FilPalette;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.palette.color.Spectral;
import org.jensoft.core.plugin.donut3d.Donut3D;
import org.jensoft.core.plugin.donut3d.Donut3DPlugin;
import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.Donut3DToolkit;
import org.jensoft.core.plugin.donut3d.painter.label.AbstractDonut3DSliceLabel;
import org.jensoft.core.plugin.donut3d.painter.label.Donut3DBorderLabel;
import org.jensoft.core.plugin.legend.title.TitleLegend;
import org.jensoft.core.plugin.legend.title.TitleLegendConstraints;
import org.jensoft.core.plugin.legend.title.TitleLegendPlugin;
import org.jensoft.core.plugin.legend.title.painter.fil.TitleLegendGradientFill;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.background.ViewNoBackground;

@JenSoftView(background=ViewNoBackground.class, description="Show how to use border label with line style on donut3D slice.")
public class Donut3DPlugin_Label_Border_view1
extends View {
    private static final long serialVersionUID = 2180485799535868986L;

    public static void main(String[] args) {
        ViewFrameUI ui = new ViewFrameUI(new Donut3DPlugin_Label_Border_view1());
    }

    public Donut3DPlugin_Label_Border_view1() {
        super(0);
        Projection.Linear proj = new Projection.Linear(-1.0, 1.0, -1.0, 1.0);
        proj.setName("donut3D proj");
        this.registerProjection(proj);
        Donut3DPlugin donut3DPlugin = new Donut3DPlugin();
        proj.registerPlugin(donut3DPlugin);
        Donut3D donut3d = Donut3DToolkit.createDonut3D("myDonut", 70.0, 120.0, 50.0, 60.0, 40.0);
        donut3DPlugin.addDonut(donut3d);
        donut3d.setStartAngleDegree(20.0);
        Donut3DSlice s1 = Donut3DToolkit.createDonut3DSlice("s1", new Color(250, 250, 250), 45.0);
        Donut3DSlice s2 = Donut3DToolkit.createDonut3DSlice("s2", NanoChromatique.ORANGE, 8.0);
        Donut3DSlice s3 = Donut3DToolkit.createDonut3DSlice("s3", RosePalette.COALBLACK, 15.0);
        Donut3DSlice s4 = Donut3DToolkit.createDonut3DSlice("s4", Spectral.SPECTRAL_BLUE1, 30.0);
        Donut3DToolkit.pushSlices(donut3d, s1, s2, s3, s4);
        float[] fractions = new float[]{0.0f, 0.5f, 1.0f};
        Color[] c = new Color[]{new Color(0, 0, 0, 100), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255)};
        Font f = new Font("Dialog", 0, 12);
        Donut3DBorderLabel label1 = Donut3DToolkit.createBorderLabel("Symbian", RosePalette.COALBLACK, f, 20, AbstractDonut3DSliceLabel.Style.Both);
        label1.setLinkColor(RosePalette.LEMONPEEL);
        label1.setLabelColor(ColorPalette.WHITE);
        label1.setOutlineColor(Color.BLACK);
        label1.setShader(fractions, c);
        s1.addSliceLabel(label1);
        TitleLegend legend = new TitleLegend("Slice Border Label");
        legend.setLegendFill(new TitleLegendGradientFill(Color.WHITE, FilPalette.GREEN5));
        legend.setFont(f);
        legend.setConstraints(new TitleLegendConstraints(TitleLegendConstraints.LegendPosition.South, 0.8f, TitleLegendConstraints.LegendAlignment.Rigth));
        TitleLegendPlugin legendPlg = new TitleLegendPlugin();
        legendPlg.addLegend(legend);
        proj.registerPlugin(legendPlg);
    }
}

