/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut3d.animator;

import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.animator.AbstractDonut3DAnimator;
import org.jensoft.core.plugin.donut3d.painter.label.AbstractDonut3DSliceLabel;

public class Donut3DLabelAnimator
extends AbstractDonut3DAnimator {
    private Donut3DSlice slice;
    private AbstractDonut3DSliceLabel sliceLabel;
    private ShowLabelBehavior showLabelBehavior = ShowLabelBehavior.ShowOnSliceRollover;

    public Donut3DLabelAnimator(Donut3DSlice slice, AbstractDonut3DSliceLabel sliceLabel) {
        this.slice = slice;
        this.sliceLabel = sliceLabel;
    }

    public Donut3DSlice getSlice() {
        return this.slice;
    }

    public void setSlice(Donut3DSlice slice) {
        this.slice = slice;
    }

    public AbstractDonut3DSliceLabel getSliceLabel() {
        return this.sliceLabel;
    }

    public void setSliceLabel(AbstractDonut3DSliceLabel sliceLabel) {
        this.sliceLabel = sliceLabel;
    }

    public ShowLabelBehavior getShowLabelBehavior() {
        return this.showLabelBehavior;
    }

    public void setShowLabelBehavior(ShowLabelBehavior showLabelBehavior) {
        this.showLabelBehavior = showLabelBehavior;
    }

    @Override
    protected void onPressed(Donut3DSlice slice) {
        if (this.showLabelBehavior == ShowLabelBehavior.ShowOnSlicePressed && slice.equals(this.slice) && slice.equals(this.slice)) {
            Thread t = new Thread(this.getAnimator(slice));
            t.start();
        }
    }

    @Override
    protected void onEntered(Donut3DSlice slice) {
        if (this.showLabelBehavior == ShowLabelBehavior.ShowOnSliceRollover && slice.equals(this.slice) && slice.equals(this.slice)) {
            Thread t = new Thread(this.getAnimator(slice));
            t.start();
        }
    }

    @Override
    protected void onExited(Donut3DSlice slice) {
        if (this.showLabelBehavior == ShowLabelBehavior.ShowOnSliceRollover && slice.equals(this.slice) && slice.equals(this.slice)) {
            Thread t = new Thread(this.getAnimator(slice));
            t.start();
        }
    }

    @Override
    public Runnable getAnimator(Donut3DSlice pieSection) {
        return new LabelRunner(pieSection);
    }

    public class LabelRunner
    implements Runnable {
        private Donut3DSlice animateSlice;

        public LabelRunner(Donut3DSlice pieSection) {
            this.animateSlice = pieSection;
        }

        @Override
        public void run() {
            if (!this.animateSlice.containsSliceLabel(Donut3DLabelAnimator.this.sliceLabel)) {
                this.animateSlice.addSliceLabel(Donut3DLabelAnimator.this.sliceLabel);
            } else {
                this.animateSlice.removeSliceLabel(Donut3DLabelAnimator.this.sliceLabel);
            }
            Donut3DLabelAnimator.this.getView(this.animateSlice).repaintDevice();
        }
    }

    public static enum ShowLabelBehavior {
        ShowOnSlicePressed,
        ShowOnSliceRollover;

    }
}

