/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut3d.painter.label;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.donut3d.Donut3D;
import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.painter.Donut3DSlicePainter;

public abstract class AbstractDonut3DSliceLabel
implements Donut3DSlicePainter {
    private String label;
    private Color labelColor;
    private Font labelFont;
    private int outlineRound = 6;
    private Color outlineColor;
    private Stroke outlineStroke;
    private int labelPaddingX = 10;
    private int labelPaddingY = 2;
    private Color fillColor;
    private float[] shadeFractions;
    private Color[] shadeColors;
    private Stroke defaultStroke = new BasicStroke();
    private Style style = Style.Both;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }

    public void setShader(Shader shader) {
        if (shader != null) {
            this.shadeFractions = shader.getFractions();
            this.shadeColors = shader.getColors();
        }
    }

    public float[] getShadeFractions() {
        return this.shadeFractions;
    }

    public void setShadeFractions(float[] shadeFractions) {
        this.shadeFractions = shadeFractions;
    }

    public Color[] getShadeColors() {
        return this.shadeColors;
    }

    public void setShadeColors(Color[] shadeColors) {
        this.shadeColors = shadeColors;
    }

    public Stroke getDefaultStroke() {
        return this.defaultStroke;
    }

    public void setDefaultStroke(Stroke defaultStroke) {
        this.defaultStroke = defaultStroke;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public int getOutlineRound() {
        return this.outlineRound;
    }

    public void setOutlineRound(int outlineRound) {
        this.outlineRound = outlineRound;
    }

    public int getLabelPaddingX() {
        return this.labelPaddingX;
    }

    public void setLabelPaddingX(int labelPaddingX) {
        this.labelPaddingX = labelPaddingX;
    }

    public int getLabelPaddingY() {
        return this.labelPaddingY;
    }

    public void setLabelPaddingY(int labelPaddingY) {
        this.labelPaddingY = labelPaddingY;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    protected abstract void paintDonut3DSliceLabel(Graphics2D var1, Donut3D var2, Donut3DSlice var3);

    @Override
    public final void paintDonut3DSlice(Graphics2D g2d, Donut3D donut3d, Donut3DSlice donutSection) {
        this.paintDonut3DSliceLabel(g2d, donut3d, donutSection);
    }

    public static enum Style {
        Nothing,
        Stroke,
        Fill,
        Both;


        public static Style parseStyle(String style) {
            if (style == null) {
                return Both;
            }
            if (style.equalsIgnoreCase("Nothing")) {
                return Nothing;
            }
            if (style.equalsIgnoreCase("Stroke")) {
                return Stroke;
            }
            if (style.equalsIgnoreCase("Fill")) {
                return Fill;
            }
            if (style.equalsIgnoreCase("Both")) {
                return Both;
            }
            return Both;
        }
    }
}

