/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut3d.painter.label;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import org.jensoft.core.plugin.donut3d.Donut3D;
import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.painter.label.AbstractDonut3DSliceLabel;

public class Donut3DRadialLabel
extends AbstractDonut3DSliceLabel {
    private int offsetRadius = 30;

    public Donut3DRadialLabel() {
    }

    public Donut3DRadialLabel(String label, Color labelColor, Font labelFont) {
        super.setLabel(label);
        super.setLabelColor(labelColor);
        super.setLabelFont(labelFont);
    }

    public Donut3DRadialLabel(String label, Color labelColor) {
        this(label, labelColor, null);
    }

    public Donut3DRadialLabel(String label) {
        this(label, null, null);
    }

    public int getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(int offsetRadius) {
        this.offsetRadius = offsetRadius;
    }

    @Override
    protected void paintDonut3DSliceLabel(Graphics2D g2d, Donut3D donut3D, Donut3DSlice donutSection) {
        float y;
        float x;
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.setColor(donutSection.getThemeColor());
        double percent = donutSection.getNormalizedValue() * 100.0;
        DecimalFormat df = new DecimalFormat("##.##");
        String s = df.format(percent) + "%";
        if (this.getLabel() != null) {
            s = this.getLabel();
        }
        Font f = new Font("Dialog", 0, 12);
        if (this.getLabelFont() != null) {
            f = this.getLabelFont();
        }
        g2d.setFont(f);
        FontMetrics fm = g2d.getFontMetrics();
        int widthText = fm.stringWidth(s);
        int ascentText = fm.getAscent();
        int descentText = fm.getDescent();
        double centerX = donut3D.getCenterX();
        double centerY = donut3D.getCenterY();
        Point2D c = null;
        if (donut3D.getDonut3DNature() == Donut3D.Donut3DNature.Donut3DUser) {
            c = donut3D.getHostPlugin().getProjection().userToPixel(new Point2D.Double(centerX, centerY));
        }
        if (donut3D.getDonut3DNature() == Donut3D.Donut3DNature.Donut3DDevice) {
            c = new Point2D.Double(centerX, centerY);
        }
        centerX = c.getX();
        centerY = c.getY();
        double medianDegree = donutSection.getMedianDegree();
        if (medianDegree >= 360.0) {
            medianDegree -= 360.0;
        }
        double oneDegreeTiltDivergence = new Double(donutSection.getDivergence()) / 90.0;
        double tiltedDivergence = oneDegreeTiltDivergence * donut3D.getTilt();
        double exploseOffsetRadius = new Double(this.offsetRadius) / 90.0 * donut3D.getTilt();
        double px = c.getX() + (donut3D.getOuterA() + donutSection.getDivergence() + (double)this.offsetRadius) * Math.cos(Math.toRadians(medianDegree));
        double py = c.getY() - (donut3D.getOuterB() + tiltedDivergence + exploseOffsetRadius) * Math.sin(Math.toRadians(medianDegree));
        double pt = donut3D.getProjectionThickness();
        if (medianDegree >= 270.0 && medianDegree <= 360.0 || medianDegree >= 0.0 && medianDegree <= 90.0) {
            if (medianDegree >= 270.0 && medianDegree <= 360.0) {
                x = (float)px;
                y = (float)(py + (double)(fm.getAscent() / 2) + pt);
            } else {
                x = (float)px;
                y = (float)(py + (double)(fm.getAscent() / 2));
            }
        } else if (medianDegree > 180.0) {
            x = (float)(px - (double)widthText);
            y = (float)(py + (double)(fm.getAscent() / 2) + pt);
        } else {
            x = (float)(px - (double)widthText);
            y = (float)(py + (double)(fm.getAscent() / 2));
        }
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x - (float)this.getLabelPaddingX(), y - (float)ascentText - (float)this.getLabelPaddingY(), widthText + 2 * this.getLabelPaddingX(), ascentText + descentText + 2 * this.getLabelPaddingY(), this.getOutlineRound(), this.getOutlineRound());
        if (this.getStyle() == AbstractDonut3DSliceLabel.Style.Fill || this.getStyle() == AbstractDonut3DSliceLabel.Style.Both) {
            Point2D.Double end2;
            Point2D.Double start2;
            if (this.getFillColor() != null && this.getShadeFractions() == null) {
                g2d.setColor(this.getFillColor());
                g2d.fill(rect);
            }
            if (this.getFillColor() == null && this.getShadeFractions() == null) {
                g2d.setColor(donutSection.getThemeColor());
                g2d.fill(rect);
            }
            if (this.getShadeFractions() != null && this.getShadeColors() != null && !(start2 = new Point2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY() + ((RectangularShape)rect).getHeight())).equals(end2 = new Point2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY()))) {
                LinearGradientPaint p2 = new LinearGradientPaint(start2, end2, this.getShadeFractions(), this.getShadeColors());
                g2d.setPaint(p2);
                g2d.fill(rect);
            }
        }
        if (this.getStyle() == AbstractDonut3DSliceLabel.Style.Stroke || this.getStyle() == AbstractDonut3DSliceLabel.Style.Both) {
            if (this.getOutlineColor() != null) {
                g2d.setColor(this.getOutlineColor());
            } else {
                g2d.setColor(donutSection.getThemeColor().brighter());
            }
            if (this.getOutlineStroke() != null) {
                g2d.setStroke(this.getOutlineStroke());
            }
            g2d.draw(rect);
        }
        g2d.setColor(donutSection.getThemeColor());
        g2d.setStroke(this.getDefaultStroke());
        g2d.setColor(donutSection.getThemeColor().brighter());
        if (this.getLabelColor() != null) {
            g2d.setColor(this.getLabelColor());
        }
        g2d.drawString(s, x, y);
    }
}

