/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut3d.painter.paint;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jensoft.core.glyphmetrics.GeometryPath;
import org.jensoft.core.plugin.donut3d.Donut3D;
import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.painter.paint.AbstractDonut3DPaint;

public class Donut3DDefaultPaint
extends AbstractDonut3DPaint {
    private int incidenceAngleDegree = 90;
    private boolean paintTopEffect = true;
    private boolean paintInnerEffect = true;
    private boolean paintOuterEffect = true;
    private float alphaTop = 0.8f;
    private float alphaInner = 1.0f;
    private float alphaOuter = 1.0f;
    private float alphaStart = 0.8f;
    private float alphaStop = 0.8f;
    private float alphaFill = 0.7f;
    private boolean fillBackBottom = true;
    private boolean fillBackOuter = true;
    private boolean fillBackInner = true;
    private boolean fillBackTop = true;
    private boolean fillBackStart = true;
    private boolean fillBackEnd = true;
    private boolean fillFrontBottom = true;
    private boolean fillFrontOuter = true;
    private boolean fillFrontInner = true;
    private boolean fillFrontTop = true;
    private boolean fillFrontStart = true;
    private boolean fillFrontEnd = true;

    public Donut3DDefaultPaint() {
    }

    public Donut3DDefaultPaint(int incidenceAngleDegree) {
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public boolean isPaintTopEffect() {
        return this.paintTopEffect;
    }

    public void setPaintTopEffect(boolean paintTopEffect) {
        this.paintTopEffect = paintTopEffect;
    }

    public boolean isPaintInnerEffect() {
        return this.paintInnerEffect;
    }

    public void setPaintInnerEffect(boolean paintInnerEffect) {
        this.paintInnerEffect = paintInnerEffect;
    }

    public boolean isPaintOuterEffect() {
        return this.paintOuterEffect;
    }

    public void setPaintOuterEffect(boolean paintOuterEffect) {
        this.paintOuterEffect = paintOuterEffect;
    }

    public float getAlphaTop() {
        return this.alphaTop;
    }

    public void setAlphaTop(float alphaTop) {
        this.alphaTop = alphaTop;
    }

    public float getAlphaInner() {
        return this.alphaInner;
    }

    public void setAlphaInner(float alphaInner) {
        this.alphaInner = alphaInner;
    }

    public float getAlphaOuter() {
        return this.alphaOuter;
    }

    public void setAlphaOuter(float alphaOuter) {
        this.alphaOuter = alphaOuter;
    }

    public float getAlphaFill() {
        return this.alphaFill;
    }

    public void setAlphaFill(float alphaFill) {
        this.alphaFill = alphaFill;
    }

    public float getAlphaStart() {
        return this.alphaStart;
    }

    public void setAlphaStart(float alphaStart) {
        this.alphaStart = alphaStart;
    }

    public float getAlphaStop() {
        return this.alphaStop;
    }

    public void setAlphaStop(float alphaStop) {
        this.alphaStop = alphaStop;
    }

    @Override
    public final void paintDonut3D(Graphics2D g2d, Donut3D donut3d) {
        List<Donut3DSlice> slicesFragments = donut3d.getPaintOrderFragments();
        for (Donut3DSlice fragment : slicesFragments) {
            this.paintDonut3DFill2(g2d, donut3d, fragment);
            if (this.isPaintTopEffect()) {
                this.paintTopEffect(g2d, donut3d, fragment);
            }
            if (this.isPaintOuterEffect()) {
                this.paintOuterEffect(g2d, donut3d, fragment);
            }
            if (this.isPaintInnerEffect()) {
                this.paintInnerEffect(g2d, donut3d, fragment);
            }
            fragment.setPainted(true);
        }
    }

    public void paintDonut3DFill2(Graphics2D g2d, Donut3D donut3d, Donut3DSlice s) {
        if (s == null) {
            return;
        }
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaFill));
        if (this.fillBackOuter && s.getType() == Donut3DSlice.Type.Back) {
            g2d.setColor(s.getThemeColor());
            g2d.fill(s.getOuterFace());
        }
        if (this.fillBackBottom && s.getType() == Donut3DSlice.Type.Back) {
            g2d.setColor(s.getThemeColor());
            g2d.fill(s.getBottomFace());
        }
        if (this.fillBackInner && s.getType() == Donut3DSlice.Type.Back) {
            g2d.setColor(s.getThemeColor());
            Area visibleInnerBackFace = new Area(s.getInnerFace());
            visibleInnerBackFace.subtract(new Area(donut3d.getTopFace()));
            visibleInnerBackFace.subtract(new Area(s.getParentSlice().getFrontInnerFace()));
            g2d.fill(visibleInnerBackFace);
        }
        if (this.fillBackStart && s.getType() == Donut3DSlice.Type.Back && s.getParentSlice().isFirst(s)) {
            g2d.setColor(s.getThemeColor());
            g2d.fill(s.getStartFace());
            if (s.getParentSlice().isFirst(s) && (s.getParentSlice().getStartAngleDegree() <= 90.0 || s.getParentSlice().getStartAngleDegree() >= 270.0)) {
                this.paintStartEffect(g2d, donut3d, s);
            }
        }
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaFill));
        if (this.fillBackEnd && s.getType() == Donut3DSlice.Type.Back && s.getParentSlice().isLast(s)) {
            g2d.setColor(s.getThemeColor());
            g2d.fill(s.getEndFace());
            if (s.getParentSlice().isLast(s) && s.getEndAngleDegree() >= 90.0 && s.getEndAngleDegree() <= 270.0) {
                this.paintEndEffect(g2d, donut3d, s);
            }
        }
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaFill));
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaFill));
        if (this.fillBackTop && s.getType() == Donut3DSlice.Type.Back) {
            g2d.setColor(s.getParentSlice().getThemeColor());
            g2d.fill(s.getTopFace());
        }
        if (this.fillFrontInner && s.getType() == Donut3DSlice.Type.Front) {
            g2d.setColor(s.getThemeColor());
            Area a = new Area(s.getInnerFace());
            g2d.fill(a);
        }
        if (this.fillFrontBottom && s.getType() == Donut3DSlice.Type.Front) {
            g2d.setColor(s.getThemeColor());
            g2d.fill(s.getBottomFace());
        }
        if (this.fillFrontStart && s.getType() == Donut3DSlice.Type.Front && s.getParentSlice().isFirst(s)) {
            g2d.setColor(s.getThemeColor());
            g2d.fill(s.getStartFace());
            if (s.getParentSlice().isFirst(s) && (s.getStartAngleDegree() < 90.0 || s.getStartAngleDegree() > 270.0)) {
                this.paintStartEffect(g2d, donut3d, s);
            }
        }
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaFill));
        if (this.fillFrontEnd && s.getType() == Donut3DSlice.Type.Front && s.getParentSlice().isLast(s)) {
            g2d.setColor(s.getParentSlice().getThemeColor());
            g2d.fill(s.getEndFace());
            if (s.getParentSlice().isLast(s) && s.getEndAngleDegree() > 90.0 && s.getEndAngleDegree() < 270.0) {
                this.paintEndEffect(g2d, donut3d, s);
            }
        }
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaFill));
        if (this.fillFrontOuter && s.getType() == Donut3DSlice.Type.Front) {
            g2d.setColor(s.getParentSlice().getThemeColor());
            g2d.fill(s.getOuterFace());
        }
        if (this.fillFrontTop && s.getType() == Donut3DSlice.Type.Front) {
            g2d.setColor(s.getParentSlice().getThemeColor());
            g2d.fill(s.getTopFace());
        }
    }

    public void paintDonut3DFill(Graphics2D g2d, Donut3D donut3d, Donut3DSlice s) {
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaFill));
        if (s == null) {
            return;
        }
        List<Donut3DSlice> fragments = s.getFragments();
        if (fragments == null) {
            return;
        }
        if (this.fillBackOuter) {
            for (Donut3DSlice donut3dSection : fragments) {
                if (donut3dSection.getType() != Donut3DSlice.Type.Back) continue;
                g2d.setColor(s.getThemeColor());
                g2d.fill(donut3dSection.getOuterFace());
            }
        }
        if (this.fillBackBottom) {
            for (Donut3DSlice donut3dSection : fragments) {
                if (donut3dSection.getType() != Donut3DSlice.Type.Back) continue;
                g2d.setColor(s.getThemeColor());
                g2d.fill(donut3dSection.getBottomFace());
            }
        }
        if (this.fillBackInner) {
            for (Donut3DSlice fragment : fragments) {
                if (fragment.getType() != Donut3DSlice.Type.Back) continue;
                g2d.setColor(s.getThemeColor());
                Area visibleInnerBackFace = new Area(fragment.getInnerFace());
                visibleInnerBackFace.subtract(new Area(donut3d.getTopFace()));
                visibleInnerBackFace.subtract(new Area(s.getFrontInnerFace()));
                g2d.fill(visibleInnerBackFace);
            }
        }
        if (this.fillBackStart) {
            for (Donut3DSlice fragment : fragments) {
                if (fragment.getType() != Donut3DSlice.Type.Back || !s.isFirst(fragment)) continue;
                g2d.setColor(s.getThemeColor());
                g2d.fill(fragment.getStartFace());
            }
        }
        if (s.getStartAngleDegree() <= 90.0 && s.getStartAngleDegree() >= 270.0) {
            this.paintStartEffect(g2d, donut3d, s);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaFill));
        if (this.fillBackEnd) {
            for (Donut3DSlice fragment : fragments) {
                if (fragment.getType() != Donut3DSlice.Type.Back || !s.isLast(fragment)) continue;
                g2d.setColor(s.getThemeColor());
                g2d.fill(fragment.getEndFace());
            }
        }
        if (s.getEndAngleDegree() >= 90.0 && s.getEndAngleDegree() <= 270.0) {
            this.paintEndEffect(g2d, donut3d, s);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaFill));
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaFill));
        if (this.fillBackTop) {
            for (Donut3DSlice donut3dSection : fragments) {
                if (donut3dSection.getType() != Donut3DSlice.Type.Back) continue;
                g2d.setColor(s.getThemeColor());
                g2d.fill(donut3dSection.getTopFace());
            }
        }
        if (this.fillFrontInner) {
            for (Donut3DSlice fragment : fragments) {
                if (fragment.getType() != Donut3DSlice.Type.Front) continue;
                g2d.setColor(s.getThemeColor());
                Area a = new Area(fragment.getInnerFace());
                g2d.fill(a);
            }
        }
        if (this.fillFrontBottom) {
            for (Donut3DSlice donut3dSection : fragments) {
                if (donut3dSection.getType() != Donut3DSlice.Type.Front) continue;
                g2d.setColor(s.getThemeColor());
                g2d.fill(donut3dSection.getBottomFace());
            }
        }
        if (this.fillFrontStart) {
            for (Donut3DSlice fragment : fragments) {
                if (fragment.getType() != Donut3DSlice.Type.Front || !s.isFirst(fragment)) continue;
                g2d.setColor(s.getThemeColor());
                g2d.fill(fragment.getStartFace());
            }
        }
        if (s.getStartAngleDegree() < 90.0 || s.getStartAngleDegree() > 270.0) {
            this.paintStartEffect(g2d, donut3d, s);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaFill));
        if (this.fillFrontEnd) {
            for (Donut3DSlice fragment : fragments) {
                if (fragment.getType() != Donut3DSlice.Type.Front || !s.isLast(fragment)) continue;
                g2d.setColor(s.getThemeColor());
                g2d.fill(fragment.getEndFace());
            }
        }
        if (s.getEndAngleDegree() > 90.0 && s.getEndAngleDegree() < 270.0) {
            this.paintEndEffect(g2d, donut3d, s);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaFill));
        if (this.fillFrontOuter) {
            for (Donut3DSlice donut3dSection : fragments) {
                if (donut3dSection.getType() != Donut3DSlice.Type.Front) continue;
                g2d.setColor(s.getThemeColor());
                g2d.fill(donut3dSection.getOuterFace());
            }
        }
        if (this.fillFrontTop) {
            for (Donut3DSlice donut3dSection : fragments) {
                if (donut3dSection.getType() != Donut3DSlice.Type.Front) continue;
                g2d.setColor(s.getThemeColor());
                g2d.fill(donut3dSection.getTopFace());
            }
        }
    }

    public int getIncidenceAngleDegree() {
        return this.incidenceAngleDegree;
    }

    public void setIncidenceAngleDegree(int incidenceAngleDegree) {
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public void paintTopEffect(Graphics2D g2d, Donut3D donut3d, Donut3DSlice section) {
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaTop));
        double centerX = donut3d.getCenterX();
        double centerY = donut3d.getCenterY();
        Point2D c = null;
        if (donut3d.getDonut3DNature() == Donut3D.Donut3DNature.Donut3DUser) {
            c = donut3d.getHostPlugin().getProjection().userToPixel(new Point2D.Double(centerX, centerY));
        }
        if (donut3d.getDonut3DNature() == Donut3D.Donut3DNature.Donut3DDevice) {
            c = new Point2D.Double(centerX, centerY);
        }
        centerX = c.getX();
        centerY = c.getY();
        Donut3DSlice startSection = donut3d.getSliceOnAngle(this.incidenceAngleDegree);
        if (startSection == null) {
            return;
        }
        double exploseStartTiltRadius = new Double(startSection.getDivergence()) / 90.0;
        double exploseStartRadius = exploseStartTiltRadius * donut3d.getTilt();
        double exploseStartA = startSection.getDivergence();
        double exploseStartB = exploseStartRadius;
        double centerStartX = centerX + exploseStartA * Math.cos(Math.toRadians(startSection.getStartAngleDegree() + startSection.getExtendsDegree() / 2.0));
        double centerStartY = centerY - exploseStartB * Math.sin(Math.toRadians(startSection.getStartAngleDegree() + startSection.getExtendsDegree() / 2.0));
        double startX = centerStartX + donut3d.getOuterA() * Math.cos(Math.toRadians(this.incidenceAngleDegree));
        double startY = centerStartY - donut3d.getOuterB() * Math.sin(Math.toRadians(this.incidenceAngleDegree));
        Donut3DSlice endSection = donut3d.getSliceOnAngle(this.incidenceAngleDegree + 180);
        if (endSection == null) {
            return;
        }
        double exploseEndTiltRadius = new Double(endSection.getDivergence()) / 90.0;
        double exploseEndRadius = exploseEndTiltRadius * donut3d.getTilt();
        double exploseEndA = endSection.getDivergence();
        double exploseEndB = exploseEndRadius;
        double centerEndX = centerX + exploseEndA * Math.cos(Math.toRadians(endSection.getStartAngleDegree() + endSection.getExtendsDegree() / 2.0));
        double centerEndY = centerY - exploseEndB * Math.sin(Math.toRadians(endSection.getStartAngleDegree() + endSection.getExtendsDegree() / 2.0));
        double endX = centerEndX + donut3d.getOuterA() * Math.cos(Math.toRadians(this.incidenceAngleDegree + 180));
        double endY = centerEndY - donut3d.getOuterB() * Math.sin(Math.toRadians(this.incidenceAngleDegree + 180));
        Point2D.Double start1 = new Point2D.Double(startX, startY);
        Point2D.Double end1 = new Point2D.Double(endX, endY);
        float[] dist1 = new float[]{0.0f, 0.45f, 0.55f, 1.0f};
        Color cStart1 = new Color(40, 40, 40, 150);
        Color cStart1bis = new Color(40, 40, 40, 0);
        Color cEnd1bis = new Color(255, 255, 255, 0);
        Color cEnd1 = new Color(255, 255, 255, 200);
        Color[] colors1 = new Color[]{cStart1, cStart1bis, cEnd1bis, cEnd1};
        LinearGradientPaint p1 = new LinearGradientPaint(start1, end1, dist1, colors1);
        g2d.setPaint(p1);
        if (section != null && section.getTopFace() != null) {
            g2d.fill(section.getTopFace());
        }
    }

    public void paintOuterEffect(Graphics2D g2d, Donut3D donut3d, Donut3DSlice section) {
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaOuter));
        Area outerEffect = new Area();
        for (Donut3DSlice s : donut3d.getSlices()) {
            List<Donut3DSlice> fragments = s.getFragments();
            for (Donut3DSlice fragment : fragments) {
                if (fragment.getType() != Donut3DSlice.Type.Front) continue;
                outerEffect.add(new Area(fragment.getOuterFace()));
            }
        }
        Area outerEffect2 = new Area();
        if (section == null) {
            return;
        }
        if (section.getType() == Donut3DSlice.Type.Front) {
            outerEffect2.add(new Area(section.getOuterFace()));
        }
        Rectangle2D bound2D = outerEffect.getBounds2D();
        double startX2 = bound2D.getX();
        double startY2 = bound2D.getY();
        double endX2 = bound2D.getX() + bound2D.getWidth();
        double endY2 = bound2D.getY();
        Point2D.Double start2 = new Point2D.Double(startX2, startY2);
        Point2D.Double end2 = new Point2D.Double(endX2, endY2);
        float[] dist2 = new float[]{0.0f, 0.4f, 0.8f, 1.0f};
        Color cStart2 = new Color(40, 40, 40, 180);
        Color cStart2bis = new Color(40, 40, 40, 10);
        Color cEnd2bis = new Color(255, 255, 255, 10);
        Color cEnd2 = new Color(255, 255, 255, 180);
        Color[] colors2 = new Color[]{cStart2, cStart2bis, cEnd2bis, cEnd2};
        if (!start2.equals(end2)) {
            LinearGradientPaint p2 = new LinearGradientPaint(start2, end2, dist2, colors2);
            g2d.setPaint(p2);
            g2d.fill(outerEffect2);
        }
    }

    private void paintEndEffect(Graphics2D g2d, Donut3D donut3d, Donut3DSlice section) {
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaStop));
        Line2D lineBottom = section.getEndBottomLine();
        Line2D lineTop = section.getEndTopLine();
        double a = (lineTop.getY1() - lineTop.getY2()) / (lineTop.getX1() - lineTop.getX2());
        double bTop = lineTop.getY1() - 2.0 * a * lineTop.getX1();
        double bBottom = lineBottom.getY1() - 2.0 * a * lineBottom.getX1();
        double distanceLineTop = Math.abs(bBottom - bTop) / Math.sqrt(a * a + 1.0);
        double cxBottom = (lineBottom.getX1() + lineBottom.getX2()) / 2.0;
        double cyBottom = (lineBottom.getY1() + lineBottom.getY2()) / 2.0;
        double cxTop = (lineTop.getX1() + lineTop.getX2()) / 2.0;
        double cyTop = (lineTop.getY1() + lineTop.getY2()) / 2.0;
        GeometryPath path = new GeometryPath(lineBottom);
        float topLength = (float)Math.sqrt((lineTop.getX2() - lineTop.getX1()) * (lineTop.getX2() - lineTop.getX1()) + (lineTop.getY2() - lineTop.getY1()) * (lineTop.getY2() - lineTop.getY1()));
        double angleRadian = path.angleAtLength(topLength / 2.0f);
        double px = cxBottom + distanceLineTop * Math.cos(angleRadian + 1.5707963267948966);
        double py = cyBottom + distanceLineTop * Math.sin(angleRadian + 1.5707963267948966);
        Point2D.Double start2 = new Point2D.Double(cxBottom, cyBottom);
        Point2D.Double end2 = new Point2D.Double(px, py);
        float[] dist2 = new float[]{0.0f, 0.4f, 0.6f, 1.0f};
        Color cStart2 = new Color(40, 40, 40, 140);
        Color cStart2bis = new Color(40, 40, 40, 10);
        Color cEnd2bis = new Color(255, 255, 255, 10);
        Color cEnd2 = new Color(240, 240, 240, 140);
        Color[] colors2 = new Color[]{cStart2, cStart2bis, cEnd2bis, cEnd2};
        if (!start2.equals(end2)) {
            LinearGradientPaint p2 = new LinearGradientPaint(start2, end2, dist2, colors2);
            g2d.setPaint(p2);
            g2d.fill(section.getEndFace());
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    private void paintStartEffect(Graphics2D g2d, Donut3D donut3d, Donut3DSlice section) {
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaStart));
        Line2D lineBottom = section.getStartBottomLine();
        Line2D lineTop = section.getStartTopLine();
        double a = (lineTop.getY1() - lineTop.getY2()) / (lineTop.getX1() - lineTop.getX2());
        double bTop = lineTop.getY1() - 2.0 * a * lineTop.getX1();
        double bBottom = lineBottom.getY1() - 2.0 * a * lineBottom.getX1();
        double distanceLineTop = Math.abs(bBottom - bTop) / Math.sqrt(a * a + 1.0);
        double cxBottom = (lineBottom.getX1() + lineBottom.getX2()) / 2.0;
        double cyBottom = (lineBottom.getY1() + lineBottom.getY2()) / 2.0;
        double cxTop = (lineTop.getX1() + lineTop.getX2()) / 2.0;
        double cyTop = (lineTop.getY1() + lineTop.getY2()) / 2.0;
        GeometryPath path = new GeometryPath(lineBottom);
        float topLength = (float)Math.sqrt((lineTop.getX2() - lineTop.getX1()) * (lineTop.getX2() - lineTop.getX1()) + (lineTop.getY2() - lineTop.getY1()) * (lineTop.getY2() - lineTop.getY1()));
        double angleRadian = path.angleAtLength(topLength / 2.0f);
        double px = cxBottom - distanceLineTop * Math.cos(angleRadian + 1.5707963267948966);
        double py = cyBottom - distanceLineTop * Math.sin(angleRadian + 1.5707963267948966);
        Point2D.Double start2 = new Point2D.Double(cxBottom, cyBottom);
        Point2D.Double end2 = new Point2D.Double(px, py);
        float[] dist2 = new float[]{0.0f, 0.4f, 0.6f, 1.0f};
        Color cStart2 = new Color(40, 40, 40, 140);
        Color cStart2bis = new Color(40, 40, 40, 10);
        Color cEnd2bis = new Color(255, 255, 255, 10);
        Color cEnd2 = new Color(255, 255, 255, 140);
        Color[] colors2 = new Color[]{cStart2, cStart2bis, cEnd2bis, cEnd2};
        if (!start2.equals(end2)) {
            LinearGradientPaint p2 = new LinearGradientPaint(start2, end2, dist2, colors2);
            g2d.setPaint(p2);
            g2d.fill(section.getStartFace());
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    public void paintInnerEffect(Graphics2D g2d, Donut3D donut3d, Donut3DSlice section) {
        g2d.setComposite(AlphaComposite.getInstance(3, this.alphaInner));
        if (section == null) {
            return;
        }
        Area innerEffect = new Area();
        for (Donut3DSlice s : donut3d.getSlices()) {
            List<Donut3DSlice> fragments = s.getFragments();
            for (Donut3DSlice donut3dSection : fragments) {
                if (donut3dSection.getType() != Donut3DSlice.Type.Back) continue;
                g2d.setColor(s.getThemeColor());
                Area visibleInnerBackFace = new Area(donut3dSection.getInnerFace());
                visibleInnerBackFace.subtract(new Area(donut3d.getTopFace()));
                innerEffect.add(visibleInnerBackFace);
            }
        }
        Rectangle2D bound2DInner = innerEffect.getBounds2D();
        double startXInner = bound2DInner.getX() + bound2DInner.getWidth();
        double startYInner = bound2DInner.getY() + bound2DInner.getHeight();
        double endXInner = bound2DInner.getX();
        double endYInner = bound2DInner.getY();
        Point2D.Double startInner = new Point2D.Double(startXInner, startYInner);
        Point2D.Double endInner = new Point2D.Double(endXInner, endYInner);
        float[] distInner = new float[]{0.0f, 0.4f, 0.8f, 1.0f};
        Color cStartInner = new Color(40, 40, 40, 160);
        Color cStartInnerbis = new Color(40, 40, 40, 80);
        Color cEndInnerbis = new Color(240, 240, 240, 80);
        Color cEndInner = new Color(240, 240, 240, 160);
        Color[] colorsInner = new Color[]{cStartInner, cStartInnerbis, cEndInnerbis, cEndInner};
        if (!startInner.equals(endInner)) {
            LinearGradientPaint paintInner = new LinearGradientPaint(startInner, endInner, distInner, colorsInner);
            Area a = new Area();
            if (section.getType() == Donut3DSlice.Type.Back) {
                Area visibleInnerBackFace = new Area(section.getInnerFace());
                visibleInnerBackFace.subtract(new Area(donut3d.getTopFace()));
                visibleInnerBackFace.subtract(new Area(section.getFrontInnerFace()));
                a.add(visibleInnerBackFace);
            }
            g2d.setPaint(paintInner);
            g2d.fill(a);
        }
    }
}

