/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function;

import java.awt.Color;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.plugin.function.FunctionPlugin;
import org.jensoft.core.plugin.function.MetricsPathFunction;
import org.jensoft.core.plugin.function.source.FunctionNature;
import org.jensoft.core.plugin.function.source.SourceFunction;

public abstract class Function {
    private String name;
    private SourceFunction sourceFunction;
    private MetricsPathFunction pathFunction = new MetricsPathFunction();
    private FunctionPlugin<?> host;
    private Color themeColor;

    public Function() {
    }

    public Function(String name) {
        this();
        this.name = name;
    }

    public Function(String name, SourceFunction sourceFunction) {
        this(name);
        this.setSourceFunction(sourceFunction);
    }

    public SourceFunction getSourceFunction() {
        return this.sourceFunction;
    }

    public void setSourceFunction(SourceFunction sourceFunction) {
        this.sourceFunction = sourceFunction;
        this.sourceFunction.setHost(this);
        this.pathFunction.setSource(sourceFunction);
    }

    public Color getThemeColor() {
        return this.themeColor;
    }

    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricsPathFunction getPathFunction() {
        return this.pathFunction;
    }

    public FunctionPlugin<?> getHost() {
        return this.host;
    }

    public void setHost(FunctionPlugin<?> host) {
        this.host = host;
    }

    public void addMetricsLabel(GlyphMetric metric) {
        if (this.sourceFunction.getNature() == FunctionNature.XFunction) {
            this.pathFunction.addMetrics(metric);
        } else {
            this.pathFunction.addMetrics(metric);
        }
    }
}

